/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.el;

import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.ELBeanName;
import org.ocpsoft.rewrite.el.Expression;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;

class TypeBasedExpression
implements Expression {
    private static Logger log = Logger.getLogger(TypeBasedExpression.class);
    private final Class<?> clazz;
    private final String component;
    private String cachedExpression;

    public TypeBasedExpression(Class<?> clazz, String component) {
        this.clazz = clazz;
        this.component = component;
    }

    @Override
    public String getExpression() {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.lookupBeanName();
        }
        return this.cachedExpression;
    }

    private String lookupBeanName() {
        for (BeanNameResolver resolver : ServiceLoader.load(BeanNameResolver.class)) {
            String beanName = resolver.getBeanName(this.clazz);
            if (log.isTraceEnabled()) {
                log.trace("Service provider [{}] returned [{}] for class [{}]", new Object[]{resolver.getClass().getSimpleName(), beanName, this.clazz.getName()});
            }
            if (beanName == null) continue;
            String el = beanName + '.' + this.component;
            if (log.isTraceEnabled()) {
                log.debug("Creation of EL expression for component [{}] of class [{}] successful: {}", new Object[]{this.component, this.clazz.getName(), el});
            }
            return el;
        }
        throw new IllegalStateException("Unable to obtain EL name for bean of type [" + this.clazz.getName() + "] from any of the SPI implementations. You should conside placing a @" + ELBeanName.class.getSimpleName() + " on the class.");
    }

    public String toString() {
        return this.getExpression();
    }
}

