/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.common.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class Streams {
    private static final int BUFFER_SIZE = 2048;

    public static boolean copy(InputStream input, OutputStream output) {
        return Streams.copy(input, output, 2048);
    }

    public static boolean copy(InputStream input, OutputStream output, int bufferSize) {
        try {
            byte[] buffer = new byte[bufferSize];
            int read = input.read(buffer);
            while (read != -1) {
                output.write(buffer, 0, read);
                read = input.read(buffer);
            }
            output.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String toString(InputStream stream) {
        StringBuilder out = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[65536];
            InputStreamReader in = new InputStreamReader(stream, "UTF-8");
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    public static InputStream fromString(String data) {
        return new ByteArrayInputStream(data.getBytes());
    }

    public static void closeQuietly(Closeable source) {
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

