/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.lang.reflect.Array;
import java.util.Collection;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;

public final class ValueHolderUtil {
    private static final Logger log = Logger.getLogger(ValueHolderUtil.class);

    public static Validator<?> resolveValidator(Class<? extends Validator<?>> type) {
        try {
            Collection<Validator<?>> enriched = ServiceLoader.loadEnriched(type);
            if (enriched != null) {
                if (enriched.size() > 1 && log.isWarnEnabled()) {
                    log.warn("Multiple Validator instances available for type [" + type.getName() + "], using first of " + enriched + "");
                }
                for (Validator<?> validator : enriched) {
                    if (validator == null) continue;
                    return validator;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RewriteException("Could not instantiate Validator of type [" + type.getName() + "]", e);
        }
    }

    public static final Converter<?> resolveConverter(Class<? extends Converter<?>> type) {
        try {
            Collection<Converter<?>> enriched = ServiceLoader.loadEnriched(type);
            if (enriched != null) {
                if (enriched.size() > 1 && log.isWarnEnabled()) {
                    log.warn("Multiple Converter instances available for type [" + type.getName() + "], using first of " + enriched + "");
                }
                for (Converter<?> converter : enriched) {
                    if (converter == null) continue;
                    return converter;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RewriteException("Could not instantiate Converter of type [" + type.getName() + "]", e);
        }
    }

    public static boolean validates(Rewrite event, EvaluationContext context, Validator<?> validator, Object value) {
        if (validator != null) {
            if (value != null && value.getClass().isArray()) {
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (validator.validate(event, context, values[i])) continue;
                    return false;
                }
            } else {
                return validator.validate(event, context, value);
            }
        }
        return true;
    }

    public static Object convert(Rewrite event, EvaluationContext context, Converter<?> converter, Object value) {
        if (converter != null) {
            if (value != null && value.getClass().isArray()) {
                Object[] values = (Object[])value;
                Object[] convertedValues = new Object[values.length];
                for (int i = 0; i < convertedValues.length; ++i) {
                    convertedValues[i] = converter.convert(event, context, values[i]);
                }
                Class type = Object.class;
                for (Object object : convertedValues) {
                    if (object == null) continue;
                    type = object.getClass();
                    break;
                }
                Object[] result = (Object[])Array.newInstance(type, convertedValues.length);
                System.arraycopy(convertedValues, 0, result, 0, result.length);
                return result;
            }
            return converter.convert(event, context, value);
        }
        return value;
    }
}

