/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.RewriteLifecycleContext;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpOutboundRewriteImpl;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.RewriteProvider;

public class HttpRewriteWrappedResponse
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;

    public HttpRewriteWrappedResponse(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        HttpOutboundRewriteImpl event = new HttpOutboundRewriteImpl(this.request, (HttpServletResponse)this, url);
        this.rewrite(event);
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            return event.getOutboundURL();
        }
        return super.encodeRedirectURL(event.getOutboundURL());
    }

    public String encodeURL(String url) {
        HttpOutboundRewriteImpl event = new HttpOutboundRewriteImpl(this.request, (HttpServletResponse)this, url);
        this.rewrite(event);
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            return event.getOutboundURL();
        }
        return super.encodeURL(event.getOutboundURL());
    }

    private void rewrite(HttpOutboundServletRewrite event) {
        RewriteLifecycleContext context = (RewriteLifecycleContext)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
        for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
            rewriteLifecycleListener.beforeOutboundRewrite(event);
        }
        for (RewriteProvider rewriteProvider : context.getRewriteProviders()) {
            if (!rewriteProvider.handles(event)) continue;
            rewriteProvider.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.HANDLED)) continue;
            break;
        }
        for (RewriteLifecycleListener rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
            rewriteLifecycleListener.afterOutboundRewrite(event);
        }
    }
}

