/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IUserAgent;
import org.ocpsoft.rewrite.servlet.config.UserAgentUtil;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public abstract class UserAgent
extends HttpCondition {
    public static UserAgent matches(String pattern) {
        return new PatternUserAgent(pattern);
    }

    public static ClassificationUserAgent isMobile() {
        return new ClassificationUserAgent(Classification.MOBILE);
    }

    public static ClassificationUserAgent isTablet() {
        return new ClassificationUserAgent(Classification.TABLET);
    }

    public static ClassificationUserAgent isDesktop() {
        return new ClassificationUserAgent(Classification.DESKTOP);
    }

    private static class PatternUserAgent
    extends UserAgent
    implements IUserAgent {
        private final ParameterizedPattern expression;
        private final ParameterStore<IUserAgent.UserAgentParameter> parameters = new ParameterStore();

        private PatternUserAgent(String pattern) {
            Assert.notNull(pattern, "Scheme must not be null.");
            this.expression = new ParameterizedPattern(pattern);
            for (RegexCapture parameter : this.expression.getParameters().values()) {
                this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
            }
        }

        @Override
        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            String agent = ((HttpServletRequest)event.getRequest()).getHeader("user-agent");
            if (agent != null && this.expression.matches(event, context, agent)) {
                Map<RegexCapture, String[]> parameters = this.expression.parse(event, context, agent);
                for (RegexCapture capture : parameters.keySet()) {
                    if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public IUserAgent.UserAgentParameter where(String param) {
            return this.parameters.where(param, new IUserAgent.UserAgentParameter(this, this.expression.getParameter(param)));
        }

        @Override
        public IUserAgent.UserAgentParameter where(String param, Binding binding) {
            return (IUserAgent.UserAgentParameter)this.where(param).bindsTo(binding);
        }

        public String toString() {
            return this.expression.toString();
        }
    }

    private static class ClassificationUserAgent
    extends UserAgent {
        private final Classification type;

        private ClassificationUserAgent(Classification type) {
            Assert.notNull((Object)type, "Classification must not be null.");
            this.type = type;
        }

        @Override
        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            String userAgentStr = ((HttpServletRequest)event.getRequest()).getHeader("user-agent");
            String httpAccept = ((HttpServletRequest)event.getRequest()).getHeader("Accept");
            UserAgentUtil util = new UserAgentUtil(userAgentStr, httpAccept);
            switch (this.type) {
                case DESKTOP: {
                    return !util.isMobile();
                }
                case MOBILE: {
                    return util.isMobile();
                }
                case TABLET: {
                    return util.isTablet();
                }
            }
            return false;
        }
    }

    private static enum Classification {
        MOBILE,
        TABLET,
        DESKTOP;

    }
}

