/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IRequestParameter;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class RequestParameter
extends HttpCondition
implements IRequestParameter {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;
    private final ParameterStore<IRequestParameter.RequestParameterParameter> parameters = new ParameterStore();

    private RequestParameter(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static RequestParameter matches(String name, String value) {
        return new RequestParameter(name, value);
    }

    public static RequestParameter matchesAll(String name, String value) {
        return new AllRequestParameters(name, value);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, "{" + RequestParameter.class.getName() + "_value}");
    }

    public static RequestParameter valueExists(String value) {
        return new RequestParameter("{" + RequestParameter.class.getName() + "_name}", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String parameter : Collections.list(request.getParameterNames())) {
            if (!this.name.matches(event, context, parameter) || !this.matchesValue(event, context, request, parameter)) continue;
            Map<RegexCapture, String[]> parameters = this.name.parse(event, context, parameter);
            parameters = this.value.parse(event, context, parameter);
            for (RegexCapture capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Arrays.asList(request.getParameterValues(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRequestParameter.RequestParameterParameter where(String param) {
        return this.parameters.where(param, new IRequestParameter.RequestParameterParameter(this, this.name.getParameter(param), this.value.getParameter(param)));
    }

    @Override
    public IRequestParameter.RequestParameterParameter where(String param, Binding binding) {
        return this.where(param, binding);
    }

    public ParameterizedPattern getNameExpression() {
        return this.name;
    }

    public ParameterizedPattern getValueExpression() {
        return this.value;
    }

    public static class AllRequestParameters
    extends RequestParameter {
        public AllRequestParameters(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            HttpServletRequest request = (HttpServletRequest)event.getRequest();
            for (String name : Collections.list(request.getParameterNames())) {
                if (!this.getNameExpression().matches(event, context, name) || !this.matchesValues(event, context, request, name)) continue;
                Map<RegexCapture, String[]> parameters = this.getNameExpression().parse(event, context, name);
                parameters.putAll(this.getValueExpression().parse(event, context, name));
                for (RegexCapture capture : parameters.keySet()) {
                    if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean matchesValues(Rewrite event, EvaluationContext context, HttpServletRequest request, String name) {
            for (String contents : Arrays.asList(request.getParameterValues(name))) {
                if (this.getValueExpression().matches(event, context, contents)) continue;
                return false;
            }
            return true;
        }
    }
}

