/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.event.OutboundRewrite;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.Redirect;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class TrailingSlash
implements Rule {
    private String id;

    public static TrailingSlash remove() {
        return new RemoveTrailingSlash(){

            @Override
            public String toString() {
                return "TrailingSlash.remove()";
            }
        };
    }

    public static TrailingSlash append() {
        return new AppendTrailingSlash(){

            @Override
            public String toString() {
                return "TrailingSlash.append()";
            }
        };
    }

    public TrailingSlash withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public abstract String toString();

    private static abstract class RemoveTrailingSlash
    extends TrailingSlash {
        private RemoveTrailingSlash() {
        }

        public boolean evaluate(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRewrite)event).getAddress().getPath().endsWith("/");
            }
            return false;
        }

        public void perform(Rewrite event, EvaluationContext context) {
            String path = ((HttpServletRewrite)event).getAddress().getPath();
            String url = path.substring(0, path.length() - 1);
            if (event instanceof InboundRewrite) {
                Redirect.permanent(url).perform(event, context);
            } else if (event instanceof OutboundRewrite) {
                Substitute.with(url).perform(event, context);
            }
        }
    }

    private static abstract class AppendTrailingSlash
    extends TrailingSlash {
        private AppendTrailingSlash() {
        }

        public boolean evaluate(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return !((HttpServletRewrite)event).getAddress().getPath().endsWith("/");
            }
            return false;
        }

        public void perform(Rewrite event, EvaluationContext context) {
            String url = ((HttpServletRewrite)event).getAddress().getPath() + "/";
            if (event instanceof InboundRewrite) {
                Redirect.permanent(url).perform(event, context);
            } else if (event instanceof OutboundRewrite) {
                Substitute.with(url).perform(event, context);
            }
        }
    }
}

