/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.urlbuilder.Address;

public abstract class Query
extends HttpCondition
implements Parameterized {
    public static Query matches(final String query) {
        Assert.notNull((Object)query, (String)"URL pattern must not be null.");
        return new Query(){
            private ParameterStore store;
            final ParameterizedPatternParser pattern;
            {
                this.pattern = new RegexParameterizedPatternParser(query);
            }

            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                String queryString = null;
                if (event instanceof InboundRewrite) {
                    queryString = event.getInboundAddress().getQuery();
                } else if (event instanceof HttpOutboundServletRewrite) {
                    queryString = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getQuery();
                }
                if (this.pattern.parse(queryString == null ? "" : queryString).submit((Rewrite)event, context)) {
                    ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
                    for (Map.Entry entry : this.pattern.parse(query).getParameters(context).entrySet()) {
                        values.submit((Rewrite)event, context, this.store.get(((Parameter)entry.getKey()).getName()), (String)entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            public String toString() {
                return "Query.matches(\"" + query + "\")";
            }

            public Set<String> getRequiredParameterNames() {
                return this.pattern.getRequiredParameterNames();
            }

            public void setParameterStore(ParameterStore store) {
                this.pattern.setParameterStore(store);
                this.store = store;
            }
        };
    }

    public static Query parameterExists(final String name) {
        Assert.notNull((Object)name, (String)"Parameter name pattern must not be null.");
        return new Query(){
            final ParameterizedPatternParser pattern;
            final String parameterName;
            {
                this.pattern = new RegexParameterizedPatternParser("{" + name + "}");
                this.parameterName = name;
            }

            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                QueryStringBuilder queryString = QueryStringBuilder.createFromEncoded((String)event.getAddress().getQuery()).decode();
                for (String name2 : queryString.getParameterNames()) {
                    String[] parameterValues = queryString.getParameterValues(name2);
                    if (!this.parameterName.equals(name2)) continue;
                    if (parameterValues == null || parameterValues.length == 0) {
                        return this.pattern.parse("").matches();
                    }
                    for (String value : parameterValues) {
                        ParameterizedPatternResult parseResult = this.pattern.parse(value);
                        if (!parseResult.matches()) continue;
                        return parseResult.submit((Rewrite)event, context);
                    }
                }
                return false;
            }

            public String toString() {
                return "Query.parameterExists(\"" + name + "\")";
            }

            public Set<String> getRequiredParameterNames() {
                return this.pattern.getRequiredParameterNames();
            }

            public void setParameterStore(ParameterStore store) {
                this.pattern.setParameterStore(store);
            }
        };
    }

    public static Query valueExists(final String valuePattern) {
        Assert.notNull((Object)valuePattern, (String)"Parameter value pattern must not be null.");
        return new Query(){
            final ParameterizedPatternParser pattern;
            {
                this.pattern = new RegexParameterizedPatternParser(valuePattern);
            }

            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                QueryStringBuilder queryString = QueryStringBuilder.createFromEncoded((String)event.getAddress().getQuery()).decode();
                for (String name : queryString.getParameterNames()) {
                    for (String value : queryString.getParameterValues(name)) {
                        if (value == null || !this.pattern.parse(value).submit((Rewrite)event, context)) continue;
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return "Query.valueExists(\"" + valuePattern + "\")";
            }

            public Set<String> getRequiredParameterNames() {
                return this.pattern.getRequiredParameterNames();
            }

            public void setParameterStore(ParameterStore store) {
                this.pattern.setParameterStore(store);
            }
        };
    }
}

