/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.faces.annotation.URLAction;
import com.ocpsoft.pretty.faces.annotation.URLActions;
import com.ocpsoft.pretty.faces.annotation.URLBeanName;
import com.ocpsoft.pretty.faces.annotation.URLMapping;
import com.ocpsoft.pretty.faces.annotation.URLMappings;
import com.ocpsoft.pretty.faces.annotation.URLQueryParameter;
import com.ocpsoft.pretty.faces.annotation.URLValidator;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.ServletContext;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;
import org.ocpsoft.rewrite.annotation.scan.WebClassesFinder;
import org.ocpsoft.rewrite.annotation.scan.WebLibFinder;
import org.ocpsoft.rewrite.annotation.spi.ClassFinder;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class AnnotationConfigurationProvider
implements ConfigurationProvider {
    private static final Log log = LogFactory.getLog(AnnotationConfigurationProvider.class);
    public static final String CONFIG_SCAN_LIB_DIR = "com.ocpsoft.pretty.SCAN_LIB_DIRECTORY";
    public static final String CONFIG_BASE_PACKAGES = "com.ocpsoft.pretty.BASE_PACKAGES";

    @Override
    public PrettyConfig loadConfiguration(ServletContext servletContext) {
        String packageFilters = servletContext.getInitParameter(CONFIG_BASE_PACKAGES);
        if (packageFilters != null && packageFilters.trim().equalsIgnoreCase("none")) {
            log.debug("Annotation scanning has is disabled!");
            return null;
        }
        PackageFilter packageFilter = new PackageFilter(packageFilters);
        LazyBeanNameFinder beanNameFinder = new LazyBeanNameFinder(servletContext);
        PrettyAnnotationHandler annotationHandler = new PrettyAnnotationHandler(beanNameFinder);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        ArrayList<Object> classFinders = new ArrayList<Object>();
        ByteCodeFilter byteCodeFilter = this.getByteCodeFilter();
        classFinders.add(new WebClassesFinder(servletContext, classloader, packageFilter, byteCodeFilter));
        String jarConfig = servletContext.getInitParameter(CONFIG_SCAN_LIB_DIR);
        if (jarConfig != null && jarConfig.trim().equalsIgnoreCase("true")) {
            classFinders.add(new WebLibFinder(servletContext, classloader, packageFilter, byteCodeFilter));
        }
        for (ClassFinder classFinder : classFinders) {
            classFinder.findClasses((ClassVisitor)annotationHandler);
        }
        PrettyConfigBuilder builder = new PrettyConfigBuilder();
        annotationHandler.build(builder);
        return builder.build();
    }

    private ByteCodeFilter getByteCodeFilter() {
        HashSet<Class<URLValidator>> annotations = new HashSet<Class<URLValidator>>();
        annotations.add(URLAction.class);
        annotations.add(URLActions.class);
        annotations.add(URLBeanName.class);
        annotations.add(URLMapping.class);
        annotations.add(URLMappings.class);
        annotations.add(URLQueryParameter.class);
        annotations.add(URLValidator.class);
        ByteCodeFilter byteCodeFilter = new ByteCodeFilter(annotations);
        return byteCodeFilter;
    }
}

