/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.util;

import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.util.regex.Pattern;

public class FacesElUtils {
    private static final String EL_REGEX = "\\#\\{\\s*[^}]+\\s*\\}";
    public static final Pattern elPattern = Pattern.compile("\\#\\{\\s*[^}]+\\s*\\}");

    public Object coerceToType(FacesContext context, String expression, Object value) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(context.getELContext(), expression, Object.class);
        return ef.coerceToType(value, ve.getType(context.getELContext()));
    }

    public Class<?> getExpectedType(FacesContext context, String expression) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(context.getELContext(), expression, Object.class);
        return ve.getType(context.getELContext());
    }

    public Object getValue(FacesContext context, String expression) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(context.getELContext(), expression, Object.class);
        return ve.getValue(context.getELContext());
    }

    public Object invokeMethod(FacesContext context, String expression) throws ELException {
        return this.invokeMethod(context, expression, new Class[0], null);
    }

    public Object invokeMethod(FacesContext context, String expression, Class<?>[] argumentTypes, Object[] argumentValues) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        MethodExpression me = ef.createMethodExpression(context.getELContext(), expression, Object.class, (Class[])argumentTypes);
        return me.invoke(context.getELContext(), argumentValues);
    }

    public boolean isEl(String viewId) {
        if (viewId == null) {
            return false;
        }
        return elPattern.matcher(viewId).matches();
    }

    public void setValue(FacesContext context, String expression, Object value) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(context.getELContext(), expression, Object.class);
        ve.setValue(context.getELContext(), ef.coerceToType(value, ve.getType(context.getELContext())));
    }

    public ValueExpression createValueExpression(FacesContext context, String expression) throws ELException {
        ExpressionFactory ef = context.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(context.getELContext(), expression, Object.class);
        return ve;
    }
}

