/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.rewrite.processor;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.Processor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class CustomClassProcessor
implements Processor {
    @Override
    public String processInbound(HttpServletRequest request, HttpServletResponse response, RewriteRule rule, String url) {
        String result = url;
        if (rule.getProcessor().length() > 0) {
            try {
                Class<?> processorClass = Class.forName(rule.getProcessor());
                Processor processor = (Processor)processorClass.newInstance();
                result = processor.processInbound(request, response, rule, url);
            }
            catch (Exception e) {
                throw new PrettyException("Error occurred exececuting processor of type: " + rule.getProcessor() + ", for input URL <[" + url + "]>", e);
            }
        }
        return result;
    }

    @Override
    public String processOutbound(HttpServletRequest request, HttpServletResponse response, RewriteRule rule, String url) {
        String result = url;
        if (rule.getProcessor().length() > 0) {
            try {
                Class<?> processorClass = Class.forName(rule.getProcessor());
                Processor processor = (Processor)processorClass.newInstance();
                result = processor.processOutbound(request, response, rule, url);
            }
            catch (Exception e) {
                throw new PrettyException("Error occurred exececuting processor of type: " + rule.getProcessor() + ", for input URL <[" + url + "]>", e);
            }
        }
        return result;
    }
}

