/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.event;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.beans.ActionExecutor;
import com.ocpsoft.pretty.faces.beans.ParameterInjector;
import com.ocpsoft.pretty.faces.beans.ParameterValidator;
import com.ocpsoft.pretty.faces.config.dynaview.DynaviewEngine;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.FacesMessagesUtils;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;

public class PrettyPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 2345410822999587673L;
    private final FacesMessagesUtils messagesUtils = new FacesMessagesUtils();
    private final ActionExecutor executor = new ActionExecutor();
    private final ParameterInjector injector = new ParameterInjector();
    private final ParameterValidator validator = new ParameterValidator();
    private final DynaviewEngine dynaview = new DynaviewEngine();

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            PrettyContext prettyContext = PrettyContext.getCurrentInstance(facesContext);
            if (prettyContext.shouldProcessDynaview()) {
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (viewRoot == null) {
                    viewRoot = new UIViewRoot();
                    viewRoot.setViewId("/com.ocpsoft.Dynaview.xhtml");
                    facesContext.setViewRoot(viewRoot);
                }
                facesContext.responseComplete();
            }
        } else if (!facesContext.getResponseComplete()) {
            FacesContext context = facesContext;
            this.messagesUtils.restoreMessages(context, context.getExternalContext().getRequestMap());
            this.processEvent(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            PrettyContext prettyContext = PrettyContext.getCurrentInstance(event.getFacesContext());
            boolean dynaviewViewDetermination = prettyContext.shouldProcessDynaview();
            if (!event.getFacesContext().getResponseComplete() || dynaviewViewDetermination) {
                this.validator.validateParameters(event.getFacesContext());
                if (event.getFacesContext().getResponseComplete() && !dynaviewViewDetermination) {
                    return;
                }
                this.injector.injectParameters(event.getFacesContext());
            }
            if (dynaviewViewDetermination) {
                this.dynaview.processDynaView(prettyContext, event.getFacesContext());
            } else if (!event.getFacesContext().getResponseComplete()) {
                FacesContext context = event.getFacesContext();
                this.messagesUtils.restoreMessages(context, context.getExternalContext().getRequestMap());
                this.processEvent(event);
            }
        }
    }

    private void processEvent(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        UrlMapping mapping = prettyContext.getCurrentMapping();
        if (mapping != null) {
            this.executor.executeActions(context, event.getPhaseId(), mapping);
        }
    }
}

