/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import com.ocpsoft.pretty.faces.el.PrettyExpression;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class LazyExpression
implements PrettyExpression {
    private static final Log log = LogFactory.getLog(LazyExpression.class);
    private final LazyBeanNameFinder finder;
    private final Class<?> beanClass;
    private final String component;
    private String expression;

    public LazyExpression(LazyBeanNameFinder finder, Class<?> beanClass, String component) {
        this.finder = finder;
        this.beanClass = beanClass;
        this.component = component;
    }

    @Override
    public String getELExpression() {
        if (this.expression == null) {
            this.expression = "#{" + this.finder.findBeanName(this.beanClass) + "." + this.component + "}";
            if (log.isTraceEnabled()) {
                log.trace("Lazy expression resolved to: " + this.expression);
            }
        }
        return this.expression;
    }

    public String toString() {
        return "#{[" + this.beanClass.getName() + "]." + this.component + "}";
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getComponent() {
        return this.component;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanClass == null ? 0 : this.beanClass.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LazyExpression other = (LazyExpression)obj;
        if (this.beanClass == null ? other.beanClass != null : !this.beanClass.equals(other.beanClass)) {
            return false;
        }
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }
}

