/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.UrlAction;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.FacesMessagesUtils;
import com.ocpsoft.pretty.faces.util.FacesStateUtils;
import com.ocpsoft.pretty.faces.util.PhaseIdComparator;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import java.util.List;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class ActionExecutor {
    private static final Log log = LogFactory.getLog(ActionExecutor.class);
    private static final FacesElUtils elUtils = new FacesElUtils();
    private final FacesMessagesUtils mu = new FacesMessagesUtils();

    public void executeActions(FacesContext context, PhaseId currentPhaseId, UrlMapping mapping) {
        List<UrlAction> actions = mapping.getActions();
        for (UrlAction action : actions) {
            if (!this.shouldExecute(action, currentPhaseId, FacesStateUtils.isPostback(context))) continue;
            try {
                PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
                log.trace("Invoking method: " + action + ", on request: " + prettyContext.getRequestURL());
                Object result = elUtils.invokeMethod(context, action.getAction().getELExpression());
                if (result == null) continue;
                this.mu.saveMessages(context, context.getExternalContext().getSessionMap());
                String outcome = result.toString();
                if (!"".equals(outcome)) {
                    NavigationHandler handler = context.getApplication().getNavigationHandler();
                    handler.handleNavigation(context, prettyContext.getCurrentViewId(), outcome);
                }
                return;
            }
            catch (Exception e) {
                throw new PrettyException("Exception occurred while processing <" + mapping.getId() + ":" + action.getAction() + "> " + e.getMessage(), e);
            }
        }
    }

    boolean shouldExecute(UrlAction action, PhaseId currentPhaseId, boolean isPostback) {
        boolean result = false;
        if (PhaseIdComparator.equals(action.getPhaseId(), currentPhaseId) || PhaseIdComparator.equals(action.getPhaseId(), PhaseId.ANY_PHASE)) {
            if (action.onPostback()) {
                result = true;
            } else if (!isPostback) {
                result = true;
            }
        }
        return result;
    }
}

