/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transposition;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameters;
import org.ocpsoft.rewrite.param.Transposition;

public class LocaleTransposition
implements Transposition<String>,
Constraint<String> {
    private static Map<String, ResourceBundle> bundleMap = new ConcurrentHashMap<String, ResourceBundle>();
    private final String languageParam;
    private final String bundleName;
    private Operation onFailureOperation;

    private LocaleTransposition(String languageParam, String bundleName) {
        Assert.notNull((Object)languageParam, (String)"Language must not be null.");
        Assert.notNull((Object)bundleName, (String)"Bundle must not be null.");
        this.languageParam = languageParam;
        this.bundleName = bundleName;
    }

    private String translate(String lang, String value) {
        String translatation = null;
        if (value != null) {
            if (!bundleMap.containsKey(lang)) {
                Locale locale = new Locale(lang);
                try {
                    ResourceBundle loadedBundle = ResourceBundle.getBundle(this.bundleName, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
                    bundleMap.put(lang, loadedBundle);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }
            try {
                translatation = bundleMap.get(lang).getString(value);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return translatation;
    }

    public static LocaleTransposition bundle(String bundleName, String localeParam) {
        return new LocaleTransposition(localeParam, bundleName);
    }

    public LocaleTransposition onTranspositionFailed(Operation onFailureOperation) {
        this.onFailureOperation = onFailureOperation;
        return this;
    }

    @Override
    public String transpose(Rewrite event, EvaluationContext context, String value) {
        String targetLang = Parameters.retrieve(context, this.languageParam);
        String transposedValue = this.translate(targetLang, value);
        if (transposedValue == null) {
            if (this.onFailureOperation != null) {
                context.addPreOperation(this.onFailureOperation);
            }
            transposedValue = value;
        }
        return transposedValue;
    }

    @Override
    public boolean isSatisfiedBy(Rewrite event, EvaluationContext context, String value) {
        String targetLang = Parameters.retrieve(context, this.languageParam);
        String translation = this.translate(targetLang, value);
        return translation != null;
    }
}

