/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Property;

public class IndexedComponentList {
    private static final ComponentList EMPTY_LIST = new ComponentList();
    private Map index;

    public IndexedComponentList(ComponentList list, String propertyName) {
        HashMap<String, ComponentList> indexedComponents = new HashMap<String, ComponentList>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            Iterator j = component.getProperties(propertyName).iterator();
            while (j.hasNext()) {
                Property property = (Property)j.next();
                ComponentList components = (ComponentList)indexedComponents.get(property.getValue());
                if (components == null) {
                    components = new ComponentList();
                    indexedComponents.put(property.getValue(), components);
                }
                components.add(component);
            }
        }
        this.index = Collections.unmodifiableMap(indexedComponents);
    }

    public ComponentList getComponents(String propertyValue) {
        ComponentList components = (ComponentList)this.index.get(propertyValue);
        if (components == null) {
            components = EMPTY_LIST;
        }
        return components;
    }

    public Component getComponent(String propertyValue) {
        ComponentList components = this.getComponents(propertyValue);
        if (!components.isEmpty()) {
            return (Component)components.iterator().next();
        }
        return null;
    }
}

