/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util;

import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ValidationException;

public final class PropertyValidator {
    private static final String ASSERT_NONE_MESSAGE = "Property [{0}] is not applicable";
    private static final String ASSERT_ONE_OR_LESS_MESSAGE = "Property [{0}] must only be specified once";
    private static final String ASSERT_ONE_MESSAGE = "Property [{0}] must be specified once";
    private static final String ASSERT_ONE_OR_MORE_MESSAGE = "Property [{0}] must be specified at least once";
    private static PropertyValidator instance = new PropertyValidator();

    private PropertyValidator() {
    }

    public void assertOneOrLess(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() > 1) {
            throw new ValidationException(ASSERT_ONE_OR_LESS_MESSAGE, new Object[]{propertyName});
        }
    }

    public void assertOneOrMore(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() < 1) {
            throw new ValidationException(ASSERT_ONE_OR_MORE_MESSAGE, new Object[]{propertyName});
        }
    }

    public void assertOne(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() != 1) {
            throw new ValidationException(ASSERT_ONE_MESSAGE, new Object[]{propertyName});
        }
    }

    public void assertNone(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperty(propertyName) != null) {
            throw new ValidationException(ASSERT_NONE_MESSAGE, new Object[]{propertyName});
        }
    }

    public static PropertyValidator getInstance() {
        return instance;
    }
}

