/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util;

import java.net.SocketException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.Uid;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.HostInfo;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.InetAddressHostInfo;

public class UidGenerator {
    private final String pid;
    private final HostInfo hostInfo;
    private static long lastMillis;

    public UidGenerator(String pid) throws SocketException {
        this(new InetAddressHostInfo(), pid);
    }

    public UidGenerator(HostInfo hostInfo, String pid) {
        this.hostInfo = hostInfo;
        this.pid = pid;
    }

    public Uid generateUid() {
        StringBuffer b = new StringBuffer();
        b.append(UidGenerator.uniqueTimestamp());
        b.append('-');
        b.append(this.pid);
        if (this.hostInfo != null) {
            b.append('@');
            b.append(this.hostInfo.getHostName());
        }
        return new Uid(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTime uniqueTimestamp() {
        long currentMillis;
        Class clazz = UidGenerator.class;
        synchronized (clazz) {
            currentMillis = System.currentTimeMillis();
            if (currentMillis < lastMillis) {
                currentMillis = lastMillis;
            }
            if (currentMillis - lastMillis < 1000L) {
                currentMillis += 1000L;
            }
            lastMillis = currentMillis;
        }
        DateTime timestamp = new DateTime(currentMillis);
        timestamp.setUtc(true);
        return timestamp;
    }
}

