/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.filter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.filter.Rule;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.LogFactory;

public class Filter {
    public static final int MATCH_ANY = 1;
    public static final int MATCH_ALL = 2;
    private List rules;
    private int type;

    public Filter(Rule rule) {
        this(new Rule[]{rule}, 1);
    }

    public Filter(Rule[] rules, int type) {
        this.rules = Arrays.asList(rules);
        this.type = type;
    }

    public final Collection filter(Collection c) {
        if (this.getRules() != null && this.getRules().length > 0) {
            ArrayList filtered;
            try {
                filtered = (ArrayList)c.getClass().newInstance();
            }
            catch (Exception e) {
                filtered = new ArrayList();
            }
            if (this.type == 2) {
                filtered.addAll(this.matchAll(c));
            } else {
                filtered.addAll(this.matchAny(c));
            }
            return filtered;
        }
        return c;
    }

    private List matchAll(Collection c) {
        ArrayList list = new ArrayList(c);
        ArrayList temp = new ArrayList();
        for (int n = 0; n < this.getRules().length; ++n) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!this.getRules()[n].match(o)) continue;
                temp.add(o);
            }
            list = temp;
            temp = new ArrayList();
        }
        return list;
    }

    private List matchAny(Collection c) {
        ArrayList matches = new ArrayList();
        Iterator i = c.iterator();
        block0: while (i.hasNext()) {
            Object o = i.next();
            for (int n = 0; n < this.getRules().length; ++n) {
                if (!this.getRules()[n].match(o)) continue;
                matches.add(o);
                continue block0;
            }
        }
        return matches;
    }

    public final Object[] filter(Object[] objects) {
        Collection filtered = this.filter(Arrays.asList(objects));
        try {
            return filtered.toArray((Object[])Array.newInstance(objects.getClass(), filtered.size()));
        }
        catch (ArrayStoreException ase) {
            Log log = LogFactory.getLog(Filter.class);
            log.warn("Error converting to array - using default approach", ase);
            return filtered.toArray();
        }
    }

    public final Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public final void setRules(Rule[] rules) {
        this.rules = Arrays.asList(rules);
    }
}

