/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.com.joestelmach.natty;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.CalendarSource;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.WalkerState;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.CalendarBuilder;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Calendar;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Period;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PeriodList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcsSearcher {
    private static final String GMT = "GMT";
    private static final String VEVENT = "VEVENT";
    private static final String SUMMARY = "SUMMARY";
    private static final Logger _logger = Logger.getLogger("org.ocpsoft.prettytime.shade.com.joestelmach.natty");
    private Calendar _holidayCalendar;
    private String _calendarFileName;
    private TimeZone _timeZone;

    public IcsSearcher(String calendarFileName, TimeZone timeZone) {
        this._calendarFileName = calendarFileName;
        this._timeZone = timeZone;
    }

    public Map<Integer, Date> findDates(int startYear, int endYear, String eventSummary) {
        HashMap<Integer, Date> holidays = new HashMap<Integer, Date>();
        if (this._holidayCalendar == null) {
            InputStream fin = WalkerState.class.getResourceAsStream(this._calendarFileName);
            try {
                this._holidayCalendar = new CalendarBuilder().build(fin);
            }
            catch (IOException e) {
                _logger.severe("Couln't open " + this._calendarFileName);
                return holidays;
            }
            catch (ParserException e) {
                _logger.severe("Couln't parse " + this._calendarFileName);
                return holidays;
            }
        }
        Period period = null;
        try {
            DateTime from = new DateTime(startYear + "0101T000000Z");
            DateTime to = new DateTime(endYear + "1231T000000Z");
            period = new Period(from, to);
        }
        catch (ParseException e) {
            _logger.log(Level.SEVERE, "Invalid start or end year: " + startYear + ", " + endYear, e);
            return holidays;
        }
        for (Object component : this._holidayCalendar.getComponents(VEVENT)) {
            Component vevent = (Component)component;
            String summary = vevent.getProperty(SUMMARY).getValue();
            if (!summary.equals(eventSummary)) continue;
            PeriodList list = vevent.calculateRecurrenceSet(period);
            for (Object p : list) {
                DateTime date = ((Period)p).getStart();
                GregorianCalendar utcCal = CalendarSource.getCurrentCalendar();
                ((java.util.Calendar)utcCal).setTimeZone(TimeZone.getTimeZone(GMT));
                utcCal.setTime(date);
                GregorianCalendar localCal = CalendarSource.getCurrentCalendar();
                ((java.util.Calendar)localCal).setTimeZone(this._timeZone);
                localCal.set(1, utcCal.get(1));
                localCal.set(2, utcCal.get(2));
                localCal.set(5, utcCal.get(5));
                holidays.put(localCal.get(1), localCal.getTime());
            }
        }
        return holidays;
    }
}

