/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.org.antlr.stringtemplate;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplate;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateErrorListener;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateGroup;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.language.InterfaceLexer;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.language.InterfaceParser;

public class StringTemplateGroupInterface {
    protected String name;
    protected Map templates = new LinkedHashMap();
    protected StringTemplateGroupInterface superInterface = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String string, Throwable throwable) {
            System.err.println(string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }

        public void warning(String string) {
            System.out.println(string);
        }
    };

    public StringTemplateGroupInterface(Reader reader) {
        this(reader, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroupInterface(Reader reader, StringTemplateErrorListener stringTemplateErrorListener) {
        this(reader, stringTemplateErrorListener, null);
    }

    public StringTemplateGroupInterface(Reader reader, StringTemplateErrorListener stringTemplateErrorListener, StringTemplateGroupInterface stringTemplateGroupInterface) {
        this.listener = stringTemplateErrorListener;
        this.setSuperInterface(stringTemplateGroupInterface);
        this.parseInterface(reader);
    }

    public StringTemplateGroupInterface getSuperInterface() {
        return this.superInterface;
    }

    public void setSuperInterface(StringTemplateGroupInterface stringTemplateGroupInterface) {
        this.superInterface = stringTemplateGroupInterface;
    }

    protected void parseInterface(Reader reader) {
        try {
            InterfaceLexer interfaceLexer = new InterfaceLexer(reader);
            InterfaceParser interfaceParser = new InterfaceParser(interfaceLexer);
            interfaceParser.groupInterface(this);
        }
        catch (Exception exception) {
            String string = "<unknown>";
            if (this.getName() != null) {
                string = this.getName();
            }
            this.error("problem parsing group " + string + ": " + exception, exception);
        }
    }

    public void defineTemplate(String string, LinkedHashMap linkedHashMap, boolean bl) {
        TemplateDefinition templateDefinition = new TemplateDefinition(string, linkedHashMap, bl);
        this.templates.put(templateDefinition.name, templateDefinition);
    }

    public List getMissingTemplates(StringTemplateGroup stringTemplateGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get(string);
            if (templateDefinition.optional || stringTemplateGroup.isDefined(templateDefinition.name)) continue;
            arrayList.add(templateDefinition.name);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public List getMismatchedTemplates(StringTemplateGroup stringTemplateGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get(string);
            if (!stringTemplateGroup.isDefined(templateDefinition.name)) continue;
            StringTemplate stringTemplate = stringTemplateGroup.getTemplateDefinition(templateDefinition.name);
            Map map = stringTemplate.getFormalArguments();
            boolean bl = false;
            if (templateDefinition.formalArgs != null && map == null || templateDefinition.formalArgs == null && map != null || templateDefinition.formalArgs.size() != map.size()) {
                bl = true;
            }
            if (!bl) {
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (templateDefinition.formalArgs.get(string2) != null) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add(this.getTemplateSignature(templateDefinition));
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.listener != null) {
            this.listener.error(string, exception);
        } else {
            System.err.println("StringTemplate: " + string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("interface ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n");
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get(string);
            stringBuffer.append(this.getTemplateSignature(templateDefinition));
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }

    protected String getTemplateSignature(TemplateDefinition templateDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        if (templateDefinition.optional) {
            stringBuffer.append("optional ");
        }
        stringBuffer.append(templateDefinition.name);
        if (templateDefinition.formalArgs != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append('(');
            int n = 1;
            Iterator iterator = templateDefinition.formalArgs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (n > 1) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(string);
                ++n;
            }
            stringBuffer2.append(')');
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append("()");
        }
        return stringBuffer.toString();
    }

    static class TemplateDefinition {
        public String name;
        public LinkedHashMap formalArgs;
        public boolean optional = false;

        public TemplateDefinition(String string, LinkedHashMap linkedHashMap, boolean bl) {
            this.name = string;
            this.formalArgs = linkedHashMap;
            this.optional = bl;
        }
    }
}

