/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.nlp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.ocpsoft.prettytime.nlp.parse.DateGroup;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.Parser;

public class PrettyTimeParser {
    private Parser parser = new Parser();
    private Map<String, String> translations = new HashMap<String, String>();
    private Set<String> periods = new HashSet<String>();
    private final String[] tensNames = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private final String[] numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    public PrettyTimeParser(TimeZone timezone) {
        this.parser = new Parser(timezone);
    }

    public PrettyTimeParser() {
        this(TimeZone.getDefault());
        for (int hours = 0; hours < 24; ++hours) {
            for (int min = 0; min < 60; ++min) {
                this.translations.put(this.provideRepresentation(hours * 100 + min), "" + hours * 100 + min);
            }
        }
        this.translations.put(this.provideRepresentation(60), "60");
        this.translations.put(this.provideRepresentation(70), "70");
        this.translations.put(this.provideRepresentation(80), "80");
        this.translations.put(this.provideRepresentation(90), "90");
        this.translations.put(this.provideRepresentation(100), "100");
        this.periods.add("morning");
        this.periods.add("afternoon");
        this.periods.add("evening");
        this.periods.add("night");
        this.periods.add("am");
        this.periods.add("pm");
        this.periods.add("ago");
        this.periods.add("from now");
    }

    private String provideRepresentation(int number) {
        String key;
        if (number == 0) {
            key = "zero";
        } else if (number < 20) {
            key = this.numNames[number];
        } else if (number < 100) {
            int unit = number % 10;
            key = this.tensNames[number / 10] + this.numNames[unit];
        } else {
            int unit = number % 10;
            int ten = number % 100 - unit;
            int hundred = (number - ten) / 100;
            key = hundred < 20 ? this.numNames[hundred] + " hundred" : this.tensNames[hundred / 10] + this.numNames[hundred % 10] + " hundred";
            key = ten + unit < 20 && ten + unit > 10 ? key + this.numNames[ten + unit] : key + this.tensNames[ten / 10] + this.numNames[unit];
        }
        return key.trim();
    }

    public List<Date> parse(String language) {
        language = this.words2numbers(language);
        ArrayList<Date> result = new ArrayList<Date>();
        List<org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        for (org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group : groups) {
            List<Date> dates = this.relativize(group);
            result.addAll(dates);
        }
        return result;
    }

    public List<DateGroup> parseSyntax(String language) {
        language = this.words2numbers(language);
        ArrayList<DateGroup> result = new ArrayList<DateGroup>();
        List<org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        Date now = new Date();
        for (org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group : groups) {
            result.add(new DateGroupImpl(now, group));
        }
        return result;
    }

    private String words2numbers(String language) {
        for (Map.Entry<String, String> entry : this.translations.entrySet()) {
            language = language.replaceAll("\\b" + entry.getKey() + "\\b", entry.getValue());
        }
        return language;
    }

    private List<Date> relativize(org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group) {
        String matchingValue = group.getText();
        boolean ambiguous = true;
        for (String qualifier : this.periods) {
            if (!matchingValue.contains(qualifier)) continue;
            ambiguous = false;
        }
        List<Date> result = group.getDates();
        if (ambiguous) {
            Date now = new Date();
            for (int i = 0; i < result.size(); ++i) {
                Date date = result.get(i);
                while (date.before(now)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(11, 12);
                    date = calendar.getTime();
                    result.set(i, date);
                }
            }
        }
        return result;
    }

    private class DateGroupImpl
    implements DateGroup {
        private List<Date> dates;
        private int line;
        private int position;
        private Date recursUntil;
        private String text;
        private boolean recurring;
        private Date now;

        public DateGroupImpl(Date now, org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group) {
            this.now = now;
            this.dates = group.getDates();
            this.line = group.getLine();
            this.position = group.getPosition();
            this.recursUntil = group.getRecursUntil();
            this.text = group.getText();
            this.recurring = group.isRecurring();
        }

        @Override
        public List<Date> getDates() {
            return this.dates;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public Date getRecursUntil() {
            return this.recursUntil;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isRecurring() {
            return this.recurring;
        }

        @Override
        public long getRecurInterval() {
            if (this.isRecurring()) {
                return this.getDates().get(0).getTime() - this.now.getTime();
            }
            return -1L;
        }
    }
}

