/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.ocpsoft.prettytime.nlp;

import org.ocpsoft.prettytime.natty.com.joestelmach.natty.Parser;
import org.ocpsoft.prettytime.natty.java.lang.CharSequence;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuilder;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Calendar;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.HashSet;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.Set;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.org.ocpsoft.prettytime.nlp.parse.DateGroup;

public class PrettyTimeParser
extends Object {
    private Parser parser = new Parser();
    private Map<String, String> translations = new HashMap();
    private Set<String> periods = new HashSet();

    public PrettyTimeParser(TimeZone timezone) {
        this.parser = new Parser(timezone);
    }

    public PrettyTimeParser() {
        this(TimeZone.getDefault());
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.zero", (Object)"org.ocpsoft.prettytime.natty.0");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.one", (Object)"org.ocpsoft.prettytime.natty.1");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.two", (Object)"org.ocpsoft.prettytime.natty.2");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.three", (Object)"org.ocpsoft.prettytime.natty.3");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.four", (Object)"org.ocpsoft.prettytime.natty.4");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.five", (Object)"org.ocpsoft.prettytime.natty.5");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.six", (Object)"org.ocpsoft.prettytime.natty.6");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.seven", (Object)"org.ocpsoft.prettytime.natty.7");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.eight", (Object)"org.ocpsoft.prettytime.natty.8");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.nine", (Object)"org.ocpsoft.prettytime.natty.9");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.ten", (Object)"org.ocpsoft.prettytime.natty.10");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.eleven", (Object)"org.ocpsoft.prettytime.natty.11");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.twelve", (Object)"org.ocpsoft.prettytime.natty.12");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.thirteen", (Object)"org.ocpsoft.prettytime.natty.13");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.fourteen", (Object)"org.ocpsoft.prettytime.natty.14");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.fifteen", (Object)"org.ocpsoft.prettytime.natty.15");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.sixteen", (Object)"org.ocpsoft.prettytime.natty.16");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.seventeen", (Object)"org.ocpsoft.prettytime.natty.17");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.eighteen", (Object)"org.ocpsoft.prettytime.natty.18");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.nineteen", (Object)"org.ocpsoft.prettytime.natty.19");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.twenty", (Object)"org.ocpsoft.prettytime.natty.20");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.thirty", (Object)"org.ocpsoft.prettytime.natty.30");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.fourty", (Object)"org.ocpsoft.prettytime.natty.40");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.fifty", (Object)"org.ocpsoft.prettytime.natty.50");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.sixty", (Object)"org.ocpsoft.prettytime.natty.60");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.seventy", (Object)"org.ocpsoft.prettytime.natty.70");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.eighty", (Object)"org.ocpsoft.prettytime.natty.80");
        this.translations.put((Object)"org.ocpsoft.prettytime.natty.ninety", (Object)"org.ocpsoft.prettytime.natty.90");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.morning");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.afternooon");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.evening");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.night");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.am");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.pm");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.ago");
        this.periods.add((Object)"org.ocpsoft.prettytime.natty.from now");
    }

    public List<Date> parse(String language) {
        language = this.words2numbers(language);
        ArrayList result = new ArrayList();
        List<org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        for (org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup group : groups) {
            List<Date> dates = this.relativize(group);
            result.addAll(dates);
        }
        return result;
    }

    public List<DateGroup> parseSyntax(String language) {
        language = this.words2numbers(language);
        ArrayList result = new ArrayList();
        List<org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        Date now = new Date();
        for (org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup group : groups) {
            result.add((Object)new DateGroupImpl(now, group));
        }
        return result;
    }

    private String words2numbers(String language) {
        for (Map.Entry entry : this.translations.entrySet()) {
            language = language.replaceAll(new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.\\b").append((String)entry.getKey()).append((String)"org.ocpsoft.prettytime.natty.\\b").toString(), (String)entry.getValue());
        }
        return language;
    }

    private List<Date> relativize(org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup group) {
        String matchingValue = group.getText();
        boolean ambiguous = true;
        for (String qualifier : this.periods) {
            if (!matchingValue.contains((CharSequence)qualifier)) continue;
            ambiguous = false;
        }
        List<Date> result = group.getDates();
        if (ambiguous) {
            Date now = new Date();
            for (int i = 0; i < result.size(); ++i) {
                Date date = (Date)result.get(i);
                if (!date.before(now)) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(11, 12);
                date = calendar.getTime();
                result.set(i, (Object)date);
            }
        }
        return result;
    }

    private class DateGroupImpl
    extends Object
    implements DateGroup {
        private List<Date> dates;
        private int line;
        private int position;
        private Date recursUntil;
        private String text;
        private boolean recurring;
        private Date now;

        public DateGroupImpl(Date now, org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup group) {
            this.now = now;
            this.dates = group.getDates();
            this.line = group.getLine();
            this.position = group.getPosition();
            this.recursUntil = group.getRecursUntil();
            this.text = group.getText();
            this.recurring = group.isRecurring();
        }

        @Override
        public List<Date> getDates() {
            return this.dates;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public Date getRecursUntil() {
            return this.recursUntil;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isRecurring() {
            return this.recurring;
        }

        @Override
        public long getRecurInterval() {
            if (this.isRecurring()) {
                return ((Date)this.getDates().get(0)).getTime() - this.now.getTime();
            }
            return -1L;
        }
    }
}

