/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.PrintWriter;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.io.StringWriter;
import org.ocpsoft.prettytime.natty.java.io.Writer;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassLoader;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalAccessException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.InvocationTargetException;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Method;
import org.ocpsoft.prettytime.natty.java.security.AccessController;
import org.ocpsoft.prettytime.natty.java.security.PrivilegedAction;
import org.ocpsoft.prettytime.natty.java.text.DateFormat;
import org.ocpsoft.prettytime.natty.java.text.SimpleDateFormat;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.Properties;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogConfigurationException;

public class SimpleLog
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements Log,
Serializable {
    protected static final String systemPrefix = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "org/ocpsoft/prettytime/natty/yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = false;
    protected static String dateTimeFormat = "org/ocpsoft/prettytime/natty/yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    private String shortLogName = null;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$SimpleLog;

    private static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty((String)name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? simpleLogProps.getProperty(name) : prop;
    }

    private static String getStringProperty(String name, String dephault) {
        String prop = SimpleLog.getStringProperty(name);
        return prop == null ? dephault : prop;
    }

    private static boolean getBooleanProperty(String name, boolean dephault) {
        String prop = SimpleLog.getStringProperty(name);
        return prop == null ? dephault : "org.ocpsoft.prettytime.natty.true".equalsIgnoreCase(prop);
    }

    public SimpleLog(String name) {
        this.logName = name;
        this.setLevel(3);
        String lvl = SimpleLog.getStringProperty(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.log.").append(this.logName).toString());
        int i = String.valueOf((org.ocpsoft.prettytime.natty.java.lang.Object)name).lastIndexOf((String)"org.ocpsoft.prettytime.natty..");
        while (null == lvl && i > -1) {
            name = name.substring(0, i);
            lvl = SimpleLog.getStringProperty(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.log.").append(name).toString());
            i = String.valueOf((org.ocpsoft.prettytime.natty.java.lang.Object)name).lastIndexOf((String)"org.ocpsoft.prettytime.natty..");
        }
        if (null == lvl) {
            lvl = SimpleLog.getStringProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.defaultlog");
        }
        if ("org.ocpsoft.prettytime.natty.all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
        } else if ("org.ocpsoft.prettytime.natty.trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
        } else if ("org.ocpsoft.prettytime.natty.debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
        } else if ("org.ocpsoft.prettytime.natty.info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
        } else if ("org.ocpsoft.prettytime.natty.warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
        } else if ("org.ocpsoft.prettytime.natty.error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
        } else if ("org.ocpsoft.prettytime.natty.fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
        } else if ("org.ocpsoft.prettytime.natty.off".equalsIgnoreCase(lvl)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int type, org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                dateText = dateFormatter.format(now);
            }
            buf.append(dateText);
            buf.append((String)"org.ocpsoft.prettytime.natty. ");
        }
        switch (type) {
            case 1: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[TRACE] ");
                break;
            }
            case 2: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[DEBUG] ");
                break;
            }
            case 3: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[INFO] ");
                break;
            }
            case 4: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[WARN] ");
                break;
            }
            case 5: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[ERROR] ");
                break;
            }
            case 6: {
                buf.append((String)"org.ocpsoft.prettytime.natty.[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.logName.substring(this.logName.lastIndexOf((String)"org.ocpsoft.prettytime.natty..") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf((String)"org/ocpsoft/prettytime/natty//") + 1);
            }
            buf.append(String.valueOf((org.ocpsoft.prettytime.natty.java.lang.Object)this.shortLogName)).append((String)"org.ocpsoft.prettytime.natty. - ");
        } else if (showLogName) {
            buf.append(String.valueOf((org.ocpsoft.prettytime.natty.java.lang.Object)this.logName)).append((String)"org.ocpsoft.prettytime.natty. - ");
        }
        buf.append(String.valueOf((org.ocpsoft.prettytime.natty.java.lang.Object)message));
        if (t != null) {
            buf.append((String)"org.ocpsoft.prettytime.natty. <");
            buf.append(t.toString());
            buf.append((String)"org.ocpsoft.prettytime.natty.>");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter((Writer)sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        this.write(buf);
    }

    protected void write(StringBuffer buffer) {
        System.err.println(buffer.toString());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public final void debug(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    public final void debug(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t);
        }
    }

    public final void trace(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    public final void trace(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t);
        }
    }

    public final void info(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    public final void info(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t);
        }
    }

    public final void warn(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    public final void warn(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t);
        }
    }

    public final void error(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    public final void error(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t);
        }
    }

    public final void fatal(org.ocpsoft.prettytime.natty.java.lang.Object message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    public final void fatal(org.ocpsoft.prettytime.natty.java.lang.Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (classLoader == null) {
            try {
                Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = SimpleLog.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Thread")) : class$java$lang$Thread).getMethod((String)"org.ocpsoft.prettytime.natty.getContextClassLoader", (Class[])null);
                try {
                    classLoader = (ClassLoader)method.invoke((org.ocpsoft.prettytime.natty.java.lang.Object)Thread.currentThread(), (org.ocpsoft.prettytime.natty.java.lang.Object[])((Class[])null));
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof SecurityException)) {
                        throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.Unexpected InvocationTargetException", e.getTargetException());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            classLoader = (class$org$apache$commons$logging$impl$SimpleLog == null ? (class$org$apache$commons$logging$impl$SimpleLog = SimpleLog.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.SimpleLog")) : class$org$apache$commons$logging$impl$SimpleLog).getClassLoader();
        }
        return classLoader;
    }

    private static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                ClassLoader threadCL = SimpleLog.getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream((String)name);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        InputStream in = SimpleLog.getResourceAsStream((String)"org.ocpsoft.prettytime.natty.simplelog.properties");
        if (null != in) {
            try {
                simpleLogProps.load(in);
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        showLogName = SimpleLog.getBooleanProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.showlogname", showLogName);
        showShortName = SimpleLog.getBooleanProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.showShortLogname", showShortName);
        if (showDateTime = SimpleLog.getBooleanProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.showdatetime", showDateTime)) {
            dateTimeFormat = SimpleLog.getStringProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.simplelog.dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                dateTimeFormat = "org/ocpsoft/prettytime/natty/yyyy/MM/dd HH:mm:ss:SSS zzz";
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

