/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl;

import org.ocpsoft.prettytime.natty.java.lang.Boolean;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassLoader;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.ExceptionInInitializerError;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Constructor;
import org.ocpsoft.prettytime.natty.java.lang.reflect.InvocationTargetException;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Method;
import org.ocpsoft.prettytime.natty.java.net.URL;
import org.ocpsoft.prettytime.natty.java.security.AccessController;
import org.ocpsoft.prettytime.natty.java.security.PrivilegedAction;
import org.ocpsoft.prettytime.natty.java.util.Enumeration;
import org.ocpsoft.prettytime.natty.java.util.Hashtable;
import org.ocpsoft.prettytime.natty.java.util.Vector;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogConfigurationException;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    private static final String LOGGING_IMPL_LOG4J_LOGGER = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Log4JLogger";
    private static final String LOGGING_IMPL_JDK14_LOGGER = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger";
    private static final String LOGGING_IMPL_LUMBERJACK_LOGGER = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk13LumberjackLogger";
    private static final String LOGGING_IMPL_SIMPLE_LOGGER = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.SimpleLog";
    private static final String PKG_IMPL = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.";
    private static final int PKG_LEN = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.".length();
    public static final String LOG_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] classesToDiscover = new String[]{"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Log4JLogger", "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger", "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk13LumberjackLogger", "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.SimpleLog"};
    private boolean useTCCL = true;
    private String diagnosticPrefix;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.java.lang.String")) : class$java$lang$String};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory};
    private boolean allowFlawedContext;
    private boolean allowFlawedDiscovery;
    private boolean allowFlawedHierarchy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$LogFactoryImpl;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;

    public LogFactoryImpl() {
        this.initDiagnostics();
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Instance created.");
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object getAttribute(String name) {
        return this.attributes.get((org.ocpsoft.prettytime.natty.java.lang.Object)name);
    }

    public String[] getAttributeNames() {
        Vector names = new Vector();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement((org.ocpsoft.prettytime.natty.java.lang.Object)((String)keys.nextElement()));
        }
        String[] results = new String[names.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)names.elementAt(i);
        }
        return results;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Log instance = (Log)this.instances.get((org.ocpsoft.prettytime.natty.java.lang.Object)name);
        if (instance == null) {
            instance = this.newInstance(name);
            this.instances.put((org.ocpsoft.prettytime.natty.java.lang.Object)name, (org.ocpsoft.prettytime.natty.java.lang.Object)instance);
        }
        return instance;
    }

    public void release() {
        this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Releasing all known loggers");
        this.instances.clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove((org.ocpsoft.prettytime.natty.java.lang.Object)name);
    }

    public void setAttribute(String name, org.ocpsoft.prettytime.natty.java.lang.Object value) {
        if (this.logConstructor != null) {
            this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.setAttribute: call too late; configuration already performed.");
        }
        if (value == null) {
            this.attributes.remove((org.ocpsoft.prettytime.natty.java.lang.Object)name);
        } else {
            this.attributes.put((org.ocpsoft.prettytime.natty.java.lang.Object)name, value);
        }
        if (name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.use_tccl")) {
            this.useTCCL = Boolean.valueOf((String)value.toString()).booleanValue();
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    private void initDiagnostics() {
        java.lang.String classLoaderName;
        Class clazz = this.getClass();
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(clazz);
        try {
            classLoaderName = classLoader == null ? "org.ocpsoft.prettytime.natty.BOOTLOADER" : LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader);
        }
        catch (SecurityException e) {
            classLoaderName = "org.ocpsoft.prettytime.natty.UNKNOWN";
        }
        this.diagnosticPrefix = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LogFactoryImpl@").append(System.identityHashCode((org.ocpsoft.prettytime.natty.java.lang.Object)this)).append((String)"org.ocpsoft.prettytime.natty. from ").append((String)classLoaderName).append((String)"org.ocpsoft.prettytime.natty.] ").toString();
    }

    protected void logDiagnostic(String msg) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            LogFactory.logRawDiagnostic(new StringBuffer().append(this.diagnosticPrefix).append(msg).toString());
        }
    }

    protected String getLogClassName() {
        if (this.logClassName == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logConstructor;
    }

    protected boolean isJdk13LumberjackAvailable() {
        return this.isLogLibraryAvailable((String)"org.ocpsoft.prettytime.natty.Jdk13Lumberjack", (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk13LumberjackLogger");
    }

    protected boolean isJdk14Available() {
        return this.isLogLibraryAvailable((String)"org.ocpsoft.prettytime.natty.Jdk14", (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger");
    }

    protected boolean isLog4JAvailable() {
        return this.isLogLibraryAvailable((String)"org.ocpsoft.prettytime.natty.Log4J", (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Log4JLogger");
    }

    protected Log newInstance(String name) throws LogConfigurationException {
        Log instance = null;
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object[] params;
            if (this.logConstructor == null) {
                instance = this.discoverLogImplementation(name);
            } else {
                params = new org.ocpsoft.prettytime.natty.java.lang.Object[]{name};
                instance = (Log)this.logConstructor.newInstance(params);
            }
            if (this.logMethod != null) {
                params = new org.ocpsoft.prettytime.natty.java.lang.Object[]{this};
                this.logMethod.invoke((org.ocpsoft.prettytime.natty.java.lang.Object)instance, params);
            }
            return instance;
        }
        catch (LogConfigurationException lce) {
            throw lce;
        }
        catch (InvocationTargetException e) {
            Throwable c = e.getTargetException();
            if (c != null) {
                throw new LogConfigurationException(c);
            }
            throw new LogConfigurationException((Throwable)((Object)e));
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return LogFactoryImpl.access$000();
            }
        });
    }

    private static String getSystemProperty(final String key, final String def) throws SecurityException {
        return (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return System.getProperty((String)key, (String)def);
            }
        });
    }

    private ClassLoader getParentClassLoader(final ClassLoader cl) {
        try {
            return (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                    return cl.getParent();
                }
            });
        }
        catch (SecurityException ex) {
            this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[SECURITY] Unable to obtain parent classloader");
            return null;
        }
    }

    private boolean isLogLibraryAvailable(String name, String classname) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Checking for '").append(name).append((String)"org.ocpsoft.prettytime.natty.'.").toString());
        }
        try {
            Log log = this.createLogFromClass(classname, this.getClass().getName(), false);
            if (log == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Did not find '").append(name).append((String)"org.ocpsoft.prettytime.natty.'.").toString());
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Found '").append(name).append((String)"org.ocpsoft.prettytime.natty.'.").toString());
            }
            return true;
        }
        catch (LogConfigurationException e) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Logging system '").append(name).append((String)"org.ocpsoft.prettytime.natty.' is available but not useable.").toString());
            }
            return false;
        }
    }

    private String getConfigurationValue(String property) {
        block10: {
            org.ocpsoft.prettytime.natty.java.lang.Object valueObj;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Trying to get configuration for item ").append(property).toString());
            }
            if ((valueObj = this.getAttribute(property)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Found LogFactory attribute [").append(valueObj).append((String)"org.ocpsoft.prettytime.natty.] for ").append(property).toString());
                }
                return valueObj.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] No LogFactory attribute found for ").append(property).toString());
            }
            try {
                String value = LogFactoryImpl.getSystemProperty(property, null);
                if (value != null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Found system property [").append(value).append((String)"org.ocpsoft.prettytime.natty.] for ").append(property).toString());
                    }
                    return value;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] No system property found for property ").append(property).toString());
                }
            }
            catch (SecurityException e) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Security prevented reading system property ").append(property).toString());
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] No configuration defined for item ").append(property).toString());
        }
        return null;
    }

    private boolean getBooleanConfiguration(String key, boolean dflt) {
        String val = this.getConfigurationValue(key);
        if (val == null) {
            return dflt;
        }
        return Boolean.valueOf((String)val).booleanValue();
    }

    private void initConfiguration() {
        this.allowFlawedContext = this.getBooleanConfiguration((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedContext", true);
        this.allowFlawedDiscovery = this.getBooleanConfiguration((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedDiscovery", true);
        this.allowFlawedHierarchy = this.getBooleanConfiguration((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log.allowFlawedHierarchy", true);
    }

    private Log discoverLogImplementation(String logCategory) throws LogConfigurationException {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Discovering a Log implementation...");
        }
        this.initConfiguration();
        Log result = null;
        String specifiedLogClassName = this.findUserSpecifiedLogClassName();
        if (specifiedLogClassName != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Attempting to load user-specified log class '").append(specifiedLogClassName).append((String)"org.ocpsoft.prettytime.natty.'...").toString());
            }
            if ((result = this.createLogFromClass(specifiedLogClassName, logCategory, true)) == null) {
                StringBuffer messageBuffer = new StringBuffer((String)"org.ocpsoft.prettytime.natty.User-specified log class '");
                messageBuffer.append(specifiedLogClassName);
                messageBuffer.append((String)"org.ocpsoft.prettytime.natty.' cannot be found or is not useable.");
                if (specifiedLogClassName != null) {
                    this.informUponSimilarName(messageBuffer, specifiedLogClassName, (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Log4JLogger");
                    this.informUponSimilarName(messageBuffer, specifiedLogClassName, (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger");
                    this.informUponSimilarName(messageBuffer, specifiedLogClassName, (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk13LumberjackLogger");
                    this.informUponSimilarName(messageBuffer, specifiedLogClassName, (String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.SimpleLog");
                }
                throw new LogConfigurationException(messageBuffer.toString());
            }
            return result;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i = 0; i < classesToDiscover.length && result == null; ++i) {
            result = this.createLogFromClass(classesToDiscover[i], logCategory, true);
        }
        if (result == null) {
            throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.No suitable Log implementation");
        }
        return result;
    }

    private void informUponSimilarName(StringBuffer messageBuffer, String name, String candidate) {
        if (name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)candidate)) {
            return;
        }
        if (name.regionMatches(true, 0, candidate, 0, PKG_LEN + 5)) {
            messageBuffer.append((String)"org.ocpsoft.prettytime.natty. Did you mean '");
            messageBuffer.append(candidate);
            messageBuffer.append((String)"org.ocpsoft.prettytime.natty.'?");
        }
    }

    private String findUserSpecifiedLogClassName() {
        String specifiedClass;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((specifiedClass = (String)this.getAttribute((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log")) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    specifiedClass = (String)this.getAttribute((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.log");
                }
                if (specifiedClass == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        specifiedClass = LogFactoryImpl.getSystemProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log", null);
                    }
                    catch (SecurityException e) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No access allowed to system property 'org.apache.commons.logging.Log' - ").append(e.getMessage()).toString());
                    }
                }
            }
            if (specifiedClass == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    specifiedClass = LogFactoryImpl.getSystemProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.log", null);
                }
                catch (SecurityException e) {
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No access allowed to system property 'org.apache.commons.logging.log' - ").append(e.getMessage()).toString());
                }
            }
        }
        if (specifiedClass != null) {
            specifiedClass = specifiedClass.trim();
        }
        return specifiedClass;
    }

    private Log createLogFromClass(String logAdapterClassName, String logCategory, boolean affectState) throws LogConfigurationException {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Attempting to instantiate '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.'").toString());
        }
        org.ocpsoft.prettytime.natty.java.lang.Object[] params = new org.ocpsoft.prettytime.natty.java.lang.Object[]{logCategory};
        Log logAdapter = null;
        Constructor constructor = null;
        Class logAdapterClass = null;
        ClassLoader currentCL = this.getBaseClassLoader();
        while (true) {
            String msg;
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Trying to load '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)currentCL)).toString());
            try {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    String resourceName = new StringBuffer().append(logAdapterClassName.replace('.', '/')).append((String)"org.ocpsoft.prettytime.natty..class").toString();
                    URL url = currentCL != null ? currentCL.getResource(resourceName) : ClassLoader.getSystemResource((String)new StringBuffer().append(resourceName).append((String)"org.ocpsoft.prettytime.natty..class").toString());
                    if (url == null) {
                        this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Class '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' [").append(resourceName).append((String)"org.ocpsoft.prettytime.natty.] cannot be found.").toString());
                    } else {
                        this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Class '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' was found at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)url).append((String)"org.ocpsoft.prettytime.natty.'").toString());
                    }
                }
                Class c = null;
                try {
                    c = Class.forName((String)logAdapterClassName, (boolean)true, (ClassLoader)currentCL);
                }
                catch (ClassNotFoundException originalClassNotFoundException) {
                    String msg2 = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.").append(originalClassNotFoundException.getMessage()).toString();
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.The log adapter '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' is not available via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)currentCL)).append((String)"org.ocpsoft.prettytime.natty.: ").append(msg2.trim()).toString());
                    try {
                        c = Class.forName((String)logAdapterClassName);
                    }
                    catch (ClassNotFoundException secondaryClassNotFoundException) {
                        msg2 = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.").append(secondaryClassNotFoundException.getMessage()).toString();
                        this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.The log adapter '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' is not available via the LogFactoryImpl class classloader: ").append(msg2.trim()).toString());
                        break;
                    }
                }
                constructor = c.getConstructor(this.logConstructorSignature);
                org.ocpsoft.prettytime.natty.java.lang.Object o = constructor.newInstance(params);
                if (o instanceof Log) {
                    logAdapterClass = c;
                    logAdapter = (Log)o;
                    break;
                }
                this.handleFlawedHierarchy(currentCL, c);
            }
            catch (NoClassDefFoundError e) {
                msg = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.").append(e.getMessage()).toString();
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.The log adapter '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' is missing dependencies when loaded via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)currentCL)).append((String)"org.ocpsoft.prettytime.natty.: ").append(msg.trim()).toString());
                break;
            }
            catch (ExceptionInInitializerError e) {
                msg = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.").append(e.getMessage()).toString();
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.The log adapter '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' is unable to initialize itself when loaded via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)currentCL)).append((String)"org.ocpsoft.prettytime.natty.: ").append(msg.trim()).toString());
                break;
            }
            catch (LogConfigurationException e) {
                throw e;
            }
            catch (Throwable t) {
                this.handleFlawedDiscovery(logAdapterClassName, currentCL, t);
            }
            if (currentCL == null) break;
            currentCL = this.getParentClassLoader(currentCL);
        }
        if (logAdapter != null && affectState) {
            this.logClassName = logAdapterClassName;
            this.logConstructor = constructor;
            try {
                this.logMethod = logAdapterClass.getMethod((String)"org.ocpsoft.prettytime.natty.setLogFactory", this.logMethodSignature);
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Found method setLogFactory(LogFactory) in '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.'").toString());
            }
            catch (Throwable t) {
                this.logMethod = null;
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[INFO] '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)currentCL)).append((String)"org.ocpsoft.prettytime.natty. does not declare optional method ").append((String)"org.ocpsoft.prettytime.natty.setLogFactory(LogFactory)").toString());
            }
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Log adapter '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)logAdapterClass.getClassLoader())).append((String)"org.ocpsoft.prettytime.natty. has been selected for use.").toString());
        }
        return logAdapter;
    }

    private ClassLoader getBaseClassLoader() throws LogConfigurationException {
        ClassLoader thisClassLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$impl$LogFactoryImpl == null ? (class$org$apache$commons$logging$impl$LogFactoryImpl = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.LogFactoryImpl")) : class$org$apache$commons$logging$impl$LogFactoryImpl);
        if (!this.useTCCL) {
            return thisClassLoader;
        }
        ClassLoader contextClassLoader = LogFactoryImpl.getContextClassLoaderInternal();
        ClassLoader baseClassLoader = this.getLowestClassLoader(contextClassLoader, thisClassLoader);
        if (baseClassLoader == null) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[WARNING] the context classloader is not part of a parent-child relationship with the classloader that loaded LogFactoryImpl.");
                }
                return contextClassLoader;
            }
            throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
        }
        if (baseClassLoader != contextClassLoader) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Warning: the context classloader is an ancestor of the classloader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context classloader is used correctly.");
                }
            } else {
                throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
            }
        }
        return baseClassLoader;
    }

    private ClassLoader getLowestClassLoader(ClassLoader c1, ClassLoader c2) {
        ClassLoader current;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        for (current = c1; current != null; current = current.getParent()) {
            if (current != c2) continue;
            return c1;
        }
        for (current = c2; current != null; current = current.getParent()) {
            if (current != c1) continue;
            return c2;
        }
        return null;
    }

    private void handleFlawedDiscovery(String logAdapterClassName, ClassLoader classLoader, Throwable discoveryFlaw) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            InvocationTargetException ite;
            Throwable cause;
            this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Could not instantiate Log '").append(logAdapterClassName).append((String)"org.ocpsoft.prettytime.natty.' -- ").append(discoveryFlaw.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty.: ").append(discoveryFlaw.getLocalizedMessage()).toString());
            if (discoveryFlaw instanceof InvocationTargetException && (cause = (ite = (InvocationTargetException)((Object)discoveryFlaw)).getTargetException()) != null) {
                ExceptionInInitializerError eiie;
                Throwable cause2;
                this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.... InvocationTargetException: ").append(cause.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty.: ").append(cause.getLocalizedMessage()).toString());
                if (cause instanceof ExceptionInInitializerError && (cause2 = (eiie = (ExceptionInInitializerError)((Object)cause)).getException()) != null) {
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.... ExceptionInInitializerError: ").append(cause2.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty.: ").append(cause2.getLocalizedMessage()).toString());
                }
            }
        }
        if (!this.allowFlawedDiscovery) {
            throw new LogConfigurationException(discoveryFlaw);
        }
    }

    private void handleFlawedHierarchy(ClassLoader badClassLoader, Class badClass) throws LogConfigurationException {
        boolean implementsLog = false;
        String logInterfaceName = (class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log).getName();
        Class[] interfaces = badClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!logInterfaceName.equals((org.ocpsoft.prettytime.natty.java.lang.Object)interfaces[i].getName())) continue;
            implementsLog = true;
            break;
        }
        if (implementsLog) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                try {
                    ClassLoader logInterfaceClassLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log);
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Class '").append(badClass.getName()).append((String)"org.ocpsoft.prettytime.natty.' was found in classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)badClassLoader)).append((String)"org.ocpsoft.prettytime.natty.. It is bound to a Log interface which is not").append((String)"org.ocpsoft.prettytime.natty. the one loaded from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)logInterfaceClassLoader)).toString());
                }
                catch (Throwable t) {
                    this.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Error while trying to output diagnostics about bad class '").append((org.ocpsoft.prettytime.natty.java.lang.Object)badClass).append((String)"org.ocpsoft.prettytime.natty.'").toString());
                }
            }
            if (!this.allowFlawedHierarchy) {
                StringBuffer msg = new StringBuffer();
                msg.append((String)"org.ocpsoft.prettytime.natty.Terminating logging for this context ");
                msg.append((String)"org.ocpsoft.prettytime.natty.due to bad log hierarchy. ");
                msg.append((String)"org.ocpsoft.prettytime.natty.You have more than one version of '");
                msg.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log).getName());
                msg.append((String)"org.ocpsoft.prettytime.natty.' visible.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(msg.toString());
                }
                throw new LogConfigurationException(msg.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append((String)"org.ocpsoft.prettytime.natty.Warning: bad log hierarchy. ");
                msg.append((String)"org.ocpsoft.prettytime.natty.You have more than one version of '");
                msg.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log).getName());
                msg.append((String)"org.ocpsoft.prettytime.natty.' visible.");
                this.logDiagnostic(msg.toString());
            }
        } else {
            if (!this.allowFlawedDiscovery) {
                StringBuffer msg = new StringBuffer();
                msg.append((String)"org.ocpsoft.prettytime.natty.Terminating logging for this context. ");
                msg.append((String)"org.ocpsoft.prettytime.natty.Log class '");
                msg.append(badClass.getName());
                msg.append((String)"org.ocpsoft.prettytime.natty.' does not implement the Log interface.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(msg.toString());
                }
                throw new LogConfigurationException(msg.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append((String)"org.ocpsoft.prettytime.natty.[WARNING] Log class '");
                msg.append(badClass.getName());
                msg.append((String)"org.ocpsoft.prettytime.natty.' does not implement the Log interface.");
                this.logDiagnostic(msg.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ ClassLoader access$000() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }
}

