/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl;

import org.ocpsoft.prettytime.natty.java.io.PrintWriter;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.io.StringWriter;
import org.ocpsoft.prettytime.natty.java.io.Writer;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.java.util.logging.Level;
import org.ocpsoft.prettytime.natty.java.util.logging.LogRecord;
import org.ocpsoft.prettytime.natty.java.util.logging.Logger;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;

public class Jdk13LumberjackLogger
extends Object
implements Log,
Serializable {
    protected transient Logger logger = null;
    protected String name = null;
    private String sourceClassName = "org.ocpsoft.prettytime.natty.unknown";
    private String sourceMethodName = "org.ocpsoft.prettytime.natty.unknown";
    private boolean classAndMethodFound = false;
    protected static final Level dummyLevel = Level.FINE;

    public Jdk13LumberjackLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    private void log(Level level, String msg, Throwable ex) {
        if (this.getLogger().isLoggable(level)) {
            LogRecord record = new LogRecord(level, msg);
            if (!this.classAndMethodFound) {
                this.getClassAndMethod();
            }
            record.setSourceClassName(this.sourceClassName);
            record.setSourceMethodName(this.sourceMethodName);
            if (ex != null) {
                record.setThrown(ex);
            }
            this.getLogger().log(record);
        }
    }

    private void getClassAndMethod() {
        try {
            Throwable throwable = new Throwable();
            throwable.fillInStackTrace();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter);
            throwable.printStackTrace(printWriter);
            String traceString = stringWriter.getBuffer().toString();
            StringTokenizer tokenizer = new StringTokenizer(traceString, (String)"org.ocpsoft.prettytime.natty.\n");
            tokenizer.nextToken();
            String line = tokenizer.nextToken();
            while (line.indexOf(this.getClass().getName()) == -1) {
                line = tokenizer.nextToken();
            }
            while (line.indexOf(this.getClass().getName()) >= 0) {
                line = tokenizer.nextToken();
            }
            int start = line.indexOf((String)"org.ocpsoft.prettytime.natty.at ") + 3;
            int end = line.indexOf(40);
            String temp = line.substring(start, end);
            int lastPeriod = temp.lastIndexOf(46);
            this.sourceClassName = temp.substring(0, lastPeriod);
            this.sourceMethodName = temp.substring(lastPeriod + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.classAndMethodFound = true;
    }

    public void debug(Object message) {
        this.log(Level.FINE, String.valueOf((Object)message), null);
    }

    public void debug(Object message, Throwable exception) {
        this.log(Level.FINE, String.valueOf((Object)message), exception);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, String.valueOf((Object)message), null);
    }

    public void error(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf((Object)message), exception);
    }

    public void fatal(Object message) {
        this.log(Level.SEVERE, String.valueOf((Object)message), null);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf((Object)message), exception);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public void info(Object message) {
        this.log(Level.INFO, String.valueOf((Object)message), null);
    }

    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, String.valueOf((Object)message), exception);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void trace(Object message) {
        this.log(Level.FINEST, String.valueOf((Object)message), null);
    }

    public void trace(Object message, Throwable exception) {
        this.log(Level.FINEST, String.valueOf((Object)message), exception);
    }

    public void warn(Object message) {
        this.log(Level.WARNING, String.valueOf((Object)message), null);
    }

    public void warn(Object message, Throwable exception) {
        this.log(Level.WARNING, String.valueOf((Object)message), exception);
    }
}

