/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.logging;

import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.ExceptionInInitializerError;
import org.ocpsoft.prettytime.natty.java.lang.LinkageError;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Constructor;
import org.ocpsoft.prettytime.natty.java.util.Hashtable;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.NoOpLog;

public class LogSource
extends Object {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    public static void setLogImplementation(String classname) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class logclass = Class.forName((String)classname);
            Class[] argtypes = new Class[]{"org.ocpsoft.prettytime.natty.".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable t) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"org.ocpsoft.prettytime.natty.".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static Log getInstance(String name) {
        Log log = (Log)logs.get((Object)name);
        if (null == log) {
            log = LogSource.makeNewLogInstance(name);
            logs.put((Object)name, (Object)log);
        }
        return log;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name) {
        Log log = null;
        try {
            Object[] args = new Object[]{name};
            log = (Log)logImplctor.newInstance(args);
        }
        catch (Throwable t) {
            log = null;
        }
        if (null == log) {
            log = new NoOpLog(name);
        }
        return log;
    }

    public static String[] getLogNames() {
        return (String[])logs.keySet().toArray((Object[])new String[logs.size()]);
    }

    static {
        try {
            log4jIsAvailable = null != Class.forName((String)"org.ocpsoft.prettytime.natty.org.apache.log4j.Logger");
        }
        catch (Throwable t) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName((String)"org.ocpsoft.prettytime.natty.java.util.logging.Logger") && null != Class.forName((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable t) {
            jdk14IsAvailable = false;
        }
        String name = null;
        try {
            name = System.getProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.log");
            if (name == null) {
                name = System.getProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (name != null) {
            try {
                LogSource.setLogImplementation(name);
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable u) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

