/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.logging;

import org.ocpsoft.prettytime.natty.java.io.BufferedReader;
import org.ocpsoft.prettytime.natty.java.io.FileOutputStream;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.InputStreamReader;
import org.ocpsoft.prettytime.natty.java.io.OutputStream;
import org.ocpsoft.prettytime.natty.java.io.PrintStream;
import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.io.UnsupportedEncodingException;
import org.ocpsoft.prettytime.natty.java.lang.Boolean;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassCastException;
import org.ocpsoft.prettytime.natty.java.lang.ClassLoader;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Double;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.IllegalAccessException;
import org.ocpsoft.prettytime.natty.java.lang.LinkageError;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodError;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.RuntimeException;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.InvocationTargetException;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Method;
import org.ocpsoft.prettytime.natty.java.net.URL;
import org.ocpsoft.prettytime.natty.java.security.AccessController;
import org.ocpsoft.prettytime.natty.java.security.PrivilegedAction;
import org.ocpsoft.prettytime.natty.java.util.Enumeration;
import org.ocpsoft.prettytime.natty.java.util.Hashtable;
import org.ocpsoft.prettytime.natty.java.util.Properties;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogConfigurationException;

public abstract class LogFactory
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    public static final String PRIORITY_KEY = "org.ocpsoft.prettytime.natty.priority";
    public static final String TCCL_KEY = "org.ocpsoft.prettytime.natty.use_tccl";
    public static final String FACTORY_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "org.ocpsoft.prettytime.natty.commons-logging.properties";
    protected static final String SERVICE_ID = "org/ocpsoft/prettytime/natty/META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.diagnostics.dest";
    private static PrintStream diagnosticsStream = null;
    private static String diagnosticPrefix;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String WEAK_HASHTABLE_CLASSNAME = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.WeakHashtable";
    private static ClassLoader thisClassLoader;
    protected static Hashtable factories;
    protected static LogFactory nullClassLoaderFactory;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;

    protected LogFactory() {
    }

    public abstract org.ocpsoft.prettytime.natty.java.lang.Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, org.ocpsoft.prettytime.natty.java.lang.Object var2);

    private static final Hashtable createFactoryStore() {
        Hashtable result;
        block7: {
            Object storeImplementationClass;
            result = null;
            try {
                storeImplementationClass = LogFactory.getSystemProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory.HashtableImpl", null);
            }
            catch (SecurityException ex) {
                storeImplementationClass = null;
            }
            if (storeImplementationClass == null) {
                storeImplementationClass = "org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.WeakHashtable";
            }
            try {
                Class implementationClass = Class.forName((String)storeImplementationClass);
                result = (Hashtable)implementationClass.newInstance();
            }
            catch (Throwable t) {
                if ("org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.WeakHashtable".equals((org.ocpsoft.prettytime.natty.java.lang.Object)storeImplementationClass)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[ERROR] LogFactory: Load of custom hashtable failed");
                }
                System.err.println((String)"org.ocpsoft.prettytime.natty.[ERROR] LogFactory: Load of custom hashtable failed");
            }
        }
        if (result == null) {
            result = new Hashtable();
        }
        return result;
    }

    private static String trim(String src) {
        if (src == null) {
            return null;
        }
        return src.trim();
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        String factoryClass;
        ClassLoader baseClassLoader;
        Properties props;
        LogFactory factory;
        ClassLoader contextClassLoader;
        block38: {
            String useTCCLStr;
            contextClassLoader = LogFactory.getContextClassLoaderInternal();
            if (contextClassLoader == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Context classloader is null.");
            }
            if ((factory = LogFactory.getCachedFactory(contextClassLoader)) != null) {
                return factory;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] LogFactory implementation requested for the first time for context classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)contextClassLoader)).toString());
                LogFactory.logHierarchy((String)"org.ocpsoft.prettytime.natty.[LOOKUP] ", contextClassLoader);
            }
            props = LogFactory.getConfigurationFile(contextClassLoader, (String)"org.ocpsoft.prettytime.natty.commons-logging.properties");
            baseClassLoader = contextClassLoader;
            if (props != null && (useTCCLStr = props.getProperty((String)"org.ocpsoft.prettytime.natty.use_tccl")) != null && !Boolean.valueOf((String)useTCCLStr).booleanValue()) {
                baseClassLoader = thisClassLoader;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                factoryClass = LogFactory.getSystemProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory", null);
                if (factoryClass != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Creating an instance of LogFactory class '").append(factoryClass).append((String)"org.ocpsoft.prettytime.natty.' as specified by system property ").append((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory").toString());
                    }
                    factory = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [").append(LogFactory.trim(e.getMessage())).append((String)"org.ocpsoft.prettytime.natty.]. Trying alternative implementations...").toString());
                }
            }
            catch (RuntimeException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [").append(LogFactory.trim(e.getMessage())).append((String)"org.ocpsoft.prettytime.natty.] as specified by a system property.").toString());
                }
                throw e;
            }
            if (factory == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic((String)"org/ocpsoft/prettytime/natty/[LOOKUP] Looking for a resource file of name [META-INF/services/org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
                }
                try {
                    InputStream is = LogFactory.getResourceAsStream(contextClassLoader, (String)"org/ocpsoft/prettytime/natty/META-INF/services/org.apache.commons.logging.LogFactory");
                    if (is != null) {
                        BufferedReader rd;
                        try {
                            rd = new BufferedReader((Reader)new InputStreamReader(is, (String)"org.ocpsoft.prettytime.natty.UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            rd = new BufferedReader((Reader)new InputStreamReader(is));
                        }
                        String factoryClassName = rd.readLine();
                        rd.close();
                        if (factoryClassName != null && !"org.ocpsoft.prettytime.natty.".equals((org.ocpsoft.prettytime.natty.java.lang.Object)factoryClassName)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP]  Creating an instance of LogFactory class ").append(factoryClassName).append((String)"org.ocpsoft.prettytime.natty. as specified by file '").append((String)"org/ocpsoft/prettytime/natty/META-INF/services/org.apache.commons.logging.LogFactory").append((String)"org.ocpsoft.prettytime.natty.' which was present in the path of the context").append((String)"org.ocpsoft.prettytime.natty. classloader.").toString());
                            }
                            factory = LogFactory.newFactory(factoryClassName, baseClassLoader, contextClassLoader);
                        }
                        break block38;
                    }
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic((String)"org/ocpsoft/prettytime/natty/[LOOKUP] No resource file with name 'META-INF/services/org.apache.commons.logging.LogFactory' found.");
                    }
                }
                catch (Exception ex) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block38;
                    LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [").append(LogFactory.trim(ex.getMessage())).append((String)"org.ocpsoft.prettytime.natty.]. Trying alternative implementations...").toString());
                }
            }
        }
        if (factory == null) {
            if (props != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((factoryClass = props.getProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file specifies LogFactory subclass '").append(factoryClass).append((String)"org.ocpsoft.prettytime.natty.'").toString());
                    }
                    factory = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (factory == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same classloader that loaded this LogFactory class (ie not looking in the context classloader).");
            }
            factory = LogFactory.newFactory((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.impl.LogFactoryImpl", thisClassLoader, contextClassLoader);
        }
        if (factory != null) {
            LogFactory.cacheFactory(contextClassLoader, factory);
            if (props != null) {
                Enumeration names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = props.getProperty(name);
                    factory.setAttribute(name, (org.ocpsoft.prettytime.natty.java.lang.Object)value);
                }
            }
        }
        return factory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Releasing factory for classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).toString());
        }
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory factory = (LogFactory)factories.get((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader);
                if (factory != null) {
                    factory.release();
                    factories.remove((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Releasing factory for all classloaders.");
        }
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration elements = factories.elements();
            while (elements.hasMoreElements()) {
                LogFactory element = (LogFactory)elements.nextElement();
                element.release();
            }
            factories.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
        }
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException ex) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to get classloader for class '").append((org.ocpsoft.prettytime.natty.java.lang.Object)clazz).append((String)"org.ocpsoft.prettytime.natty.' due to security restrictions - ").append(ex.getMessage()).toString());
            }
            throw ex;
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return LogFactory.directGetContextClassLoader();
            }
        });
    }

    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Thread")) : class$java$lang$Thread).getMethod((String)"org.ocpsoft.prettytime.natty.getContextClassLoader", (Class[])null);
            try {
                classLoader = (ClassLoader)method.invoke((org.ocpsoft.prettytime.natty.java.lang.Object)Thread.currentThread(), (org.ocpsoft.prettytime.natty.java.lang.Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.Unexpected IllegalAccessException", (Throwable)((Object)e));
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.Unexpected InvocationTargetException", e.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException e) {
            classLoader = LogFactory.getClassLoader(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory);
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        LogFactory factory = null;
        factory = contextClassLoader == null ? nullClassLoaderFactory : (LogFactory)factories.get((org.ocpsoft.prettytime.natty.java.lang.Object)contextClassLoader);
        return factory;
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory factory) {
        if (factory != null) {
            if (classLoader == null) {
                nullClassLoaderFactory = factory;
            } else {
                factories.put((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader, (org.ocpsoft.prettytime.natty.java.lang.Object)factory);
            }
        }
    }

    protected static LogFactory newFactory(final String factoryClass, final ClassLoader classLoader, ClassLoader contextClassLoader) throws LogConfigurationException {
        org.ocpsoft.prettytime.natty.java.lang.Object result = AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return LogFactory.createFactory(factoryClass, classLoader);
            }
        });
        if (result instanceof LogConfigurationException) {
            LogConfigurationException ex = (LogConfigurationException)result;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.An error occurred while loading the factory class:").append(ex.getMessage()).toString());
            }
            throw ex;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Created object ").append(LogFactory.objectId(result)).append((String)"org.ocpsoft.prettytime.natty. to manage classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)contextClassLoader)).toString());
        }
        return (LogFactory)result;
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) {
        return LogFactory.newFactory(factoryClass, classLoader, null);
    }

    protected static org.ocpsoft.prettytime.natty.java.lang.Object createFactory(String factoryClass, ClassLoader classLoader) {
        Class logFactoryClass = null;
        try {
            block19: {
                if (classLoader != null) {
                    try {
                        logFactoryClass = classLoader.loadClass(factoryClass);
                        if ((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory).isAssignableFrom(logFactoryClass)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Loaded class ").append(logFactoryClass.getName()).append((String)"org.ocpsoft.prettytime.natty. from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).toString());
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Factory class ").append(logFactoryClass.getName()).append((String)"org.ocpsoft.prettytime.natty. loaded from classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)logFactoryClass.getClassLoader())).append((String)"org.ocpsoft.prettytime.natty. does not extend '").append((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory).getName()).append((String)"org.ocpsoft.prettytime.natty.' as loaded by this classloader.").toString());
                            LogFactory.logHierarchy((String)"org.ocpsoft.prettytime.natty.[BAD CL TREE] ", classLoader);
                        }
                        return (LogFactory)logFactoryClass.newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to locate any class called '").append(factoryClass).append((String)"org.ocpsoft.prettytime.natty.' via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).toString());
                            }
                            throw ex;
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Class '").append(factoryClass).append((String)"org.ocpsoft.prettytime.natty.' cannot be loaded").append((String)"org.ocpsoft.prettytime.natty. via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).append((String)"org.ocpsoft.prettytime.natty. - it depends on some other class that cannot").append((String)"org.ocpsoft.prettytime.natty. be found.").toString());
                            }
                            throw e;
                        }
                    }
                    catch (ClassCastException e) {
                        if (classLoader != thisClassLoader) break block19;
                        boolean implementsLogFactory = LogFactory.implementsLogFactory(logFactoryClass);
                        String msg = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.The application has specified that a custom LogFactory implementation should be used but Class '").append(factoryClass).append((String)"org.ocpsoft.prettytime.natty.' cannot be converted to '").append((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory).getName()).append((String)"org.ocpsoft.prettytime.natty.'. ").toString();
                        msg = implementsLogFactory ? new StringBuffer().append(msg).append((String)"org.ocpsoft.prettytime.natty.The conflict is caused by the presence of multiple LogFactory classes in incompatible classloaders. ").append((String)"org/ocpsoft/prettytime/natty/Background can be found in http://commons.apache.org/logging/tech.html. ").append((String)"org.ocpsoft.prettytime.natty.If you have not explicitly specified a custom LogFactory then it is likely that ").append((String)"org.ocpsoft.prettytime.natty.the container has set one without your knowledge. ").append((String)"org.ocpsoft.prettytime.natty.In this case, consider using the commons-logging-adapters.jar file or ").append((String)"org.ocpsoft.prettytime.natty.specifying the standard LogFactory from the command line. ").toString() : new StringBuffer().append(msg).append((String)"org.ocpsoft.prettytime.natty.Please check the custom implementation. ").toString();
                        msg = new StringBuffer().append(msg).append((String)"org/ocpsoft/prettytime/natty/Help can be found @http://commons.apache.org/logging/troubleshooting.html.").toString();
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(msg);
                        }
                        ClassCastException ex = new ClassCastException(msg);
                        throw ex;
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to load factory class via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).append((String)"org.ocpsoft.prettytime.natty. - trying the classloader associated with this LogFactory.").toString());
            }
            logFactoryClass = Class.forName((String)factoryClass);
            return (LogFactory)logFactoryClass.newInstance();
        }
        catch (Exception e) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.Unable to create LogFactory instance.");
            }
            if (logFactoryClass != null && !(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory).isAssignableFrom(logFactoryClass)) {
                return new LogConfigurationException((String)"org.ocpsoft.prettytime.natty.The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", (Throwable)((Object)e));
            }
            return new LogConfigurationException((Throwable)((Object)e));
        }
    }

    private static boolean implementsLogFactory(Class logFactoryClass) {
        boolean implementsLogFactory = false;
        if (logFactoryClass != null) {
            try {
                ClassLoader logFactoryClassLoader = logFactoryClass.getClassLoader();
                if (logFactoryClassLoader == null) {
                    LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] was loaded by the boot classloader");
                } else {
                    LogFactory.logHierarchy((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] ", logFactoryClassLoader);
                    Class factoryFromCustomLoader = Class.forName((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory", (boolean)false, (ClassLoader)logFactoryClassLoader);
                    implementsLogFactory = factoryFromCustomLoader.isAssignableFrom(logFactoryClass);
                    if (implementsLogFactory) {
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] ").append(logFactoryClass.getName()).append((String)"org.ocpsoft.prettytime.natty. implements LogFactory but was loaded by an incompatible classloader.").toString());
                    } else {
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] ").append(logFactoryClass.getName()).append((String)"org.ocpsoft.prettytime.natty. does not implement LogFactory.").toString());
                    }
                }
            }
            catch (SecurityException e) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] SecurityException thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: ").append(e.getMessage()).toString());
            }
            catch (LinkageError e) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] LinkageError thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: ").append(e.getMessage()).toString());
            }
            catch (ClassNotFoundException e) {
                LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by classloader which loaded the custom LogFactory implementation. Is the custom factory in the right classloader?");
            }
        }
        return implementsLogFactory;
    }

    private static InputStream getResourceAsStream(final ClassLoader loader, final String name) {
        return (InputStream)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream((String)name);
            }
        });
    }

    private static Enumeration getResources(final ClassLoader loader, final String name) {
        PrivilegedAction action = new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                try {
                    if (loader != null) {
                        return loader.getResources(name);
                    }
                    return ClassLoader.getSystemResources((String)name);
                }
                catch (IOException e) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Exception while trying to find configuration file ").append(name).append((String)"org.ocpsoft.prettytime.natty.:").append(e.getMessage()).toString());
                    }
                    return null;
                }
                catch (NoSuchMethodError e) {
                    return null;
                }
            }
        };
        org.ocpsoft.prettytime.natty.java.lang.Object result = AccessController.doPrivileged((PrivilegedAction)action);
        return (Enumeration)result;
    }

    private static Properties getProperties(final URL url) {
        PrivilegedAction action = new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                block3: {
                    try {
                        InputStream stream = url.openStream();
                        if (stream != null) {
                            Properties props = new Properties();
                            props.load(stream);
                            stream.close();
                            return props;
                        }
                    }
                    catch (IOException e) {
                        if (!LogFactory.isDiagnosticsEnabled()) break block3;
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to read URL ").append((org.ocpsoft.prettytime.natty.java.lang.Object)url).toString());
                    }
                }
                return null;
            }
        };
        return (Properties)AccessController.doPrivileged((PrivilegedAction)action);
    }

    private static final Properties getConfigurationFile(ClassLoader classLoader, String fileName) {
        URL propsUrl;
        Properties props;
        block12: {
            props = null;
            double priority = 0.0;
            propsUrl = null;
            try {
                Enumeration urls = LogFactory.getResources(classLoader, fileName);
                if (urls == null) {
                    return null;
                }
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    Properties newProps = LogFactory.getProperties(url);
                    if (newProps == null) continue;
                    if (props == null) {
                        propsUrl = url;
                        props = newProps;
                        String priorityStr = props.getProperty((String)"org.ocpsoft.prettytime.natty.priority");
                        priority = 0.0;
                        if (priorityStr != null) {
                            priority = Double.parseDouble((String)priorityStr);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file found at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)url).append((String)"org.ocpsoft.prettytime.natty.'").append((String)"org.ocpsoft.prettytime.natty. with priority ").append(priority).toString());
                        continue;
                    }
                    String newPriorityStr = newProps.getProperty((String)"org.ocpsoft.prettytime.natty.priority");
                    double newPriority = 0.0;
                    if (newPriorityStr != null) {
                        newPriority = Double.parseDouble((String)newPriorityStr);
                    }
                    if (newPriority > priority) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)url).append((String)"org.ocpsoft.prettytime.natty.'").append((String)"org.ocpsoft.prettytime.natty. with priority ").append(newPriority).append((String)"org.ocpsoft.prettytime.natty. overrides file at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)propsUrl).append((String)"org.ocpsoft.prettytime.natty.'").append((String)"org.ocpsoft.prettytime.natty. with priority ").append(priority).toString());
                        }
                        propsUrl = url;
                        props = newProps;
                        priority = newPriority;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)url).append((String)"org.ocpsoft.prettytime.natty.'").append((String)"org.ocpsoft.prettytime.natty. with priority ").append(newPriority).append((String)"org.ocpsoft.prettytime.natty. does not override file at '").append((org.ocpsoft.prettytime.natty.java.lang.Object)propsUrl).append((String)"org.ocpsoft.prettytime.natty.'").append((String)"org.ocpsoft.prettytime.natty. with priority ").append(priority).toString());
                }
            }
            catch (SecurityException e) {
                if (!LogFactory.isDiagnosticsEnabled()) break block12;
                LogFactory.logDiagnostic((String)"org/ocpsoft/prettytime/natty/SecurityException thrown while trying to find/read config files.");
            }
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (props == null) {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] No properties file of name '").append(fileName).append((String)"org.ocpsoft.prettytime.natty.' found.").toString());
            } else {
                LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LOOKUP] Properties file of name '").append(fileName).append((String)"org.ocpsoft.prettytime.natty.' found at '").append(propsUrl).append('\"').toString());
            }
        }
        return props;
    }

    private static String getSystemProperty(final String key, final String def) throws SecurityException {
        return (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return System.getProperty((String)key, (String)def);
            }
        });
    }

    private static void initDiagnostics() {
        java.lang.String classLoaderName;
        String dest;
        try {
            dest = LogFactory.getSystemProperty((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.diagnostics.dest", null);
            if (dest == null) {
                return;
            }
        }
        catch (SecurityException ex) {
            return;
        }
        if (dest.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.STDOUT")) {
            diagnosticsStream = System.out;
        } else if (dest.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.STDERR")) {
            diagnosticsStream = System.err;
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(dest, true);
                diagnosticsStream = new PrintStream((OutputStream)fos);
            }
            catch (IOException ex) {
                return;
            }
        }
        try {
            ClassLoader classLoader = thisClassLoader;
            classLoaderName = thisClassLoader == null ? "org.ocpsoft.prettytime.natty.BOOTLOADER" : LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader);
        }
        catch (SecurityException e) {
            classLoaderName = "org.ocpsoft.prettytime.natty.UNKNOWN";
        }
        diagnosticPrefix = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[LogFactory from ").append((String)classLoaderName).append((String)"org.ocpsoft.prettytime.natty.] ").toString();
    }

    protected static boolean isDiagnosticsEnabled() {
        return diagnosticsStream != null;
    }

    private static final void logDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            diagnosticsStream.print(diagnosticPrefix);
            diagnosticsStream.println(msg);
            diagnosticsStream.flush();
        }
    }

    protected static final void logRawDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            diagnosticsStream.println(msg);
            diagnosticsStream.flush();
        }
    }

    private static void logClassLoaderEnvironment(Class clazz) {
        ClassLoader classLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Extension directories (java.ext.dir): ").append(System.getProperty((String)"org.ocpsoft.prettytime.natty.java.ext.dir")).toString());
            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Application classpath (java.class.path): ").append(System.getProperty((String)"org.ocpsoft.prettytime.natty.java.class.path")).toString());
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String className = clazz.getName();
        try {
            classLoader = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Security forbids determining the classloader for ").append(className).toString());
            return;
        }
        LogFactory.logDiagnostic(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Class ").append(className).append((String)"org.ocpsoft.prettytime.natty. was loaded via classloader ").append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).toString());
        LogFactory.logHierarchy(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[ENV] Ancestry of classloader which loaded ").append(className).append((String)"org.ocpsoft.prettytime.natty. is ").toString(), classLoader);
    }

    private static void logHierarchy(String prefix, ClassLoader classLoader) {
        ClassLoader systemClassLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            String classLoaderString = classLoader.toString();
            LogFactory.logDiagnostic(new StringBuffer().append(prefix).append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader)).append((String)"org.ocpsoft.prettytime.natty. == '").append(classLoaderString).append((String)"org.ocpsoft.prettytime.natty.'").toString());
        }
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException ex) {
            LogFactory.logDiagnostic(new StringBuffer().append(prefix).append((String)"org.ocpsoft.prettytime.natty.Security forbids determining the system classloader.").toString());
            return;
        }
        if (classLoader != null) {
            StringBuffer buf;
            block9: {
                buf = new StringBuffer(new StringBuffer().append(prefix).append((String)"org.ocpsoft.prettytime.natty.ClassLoader tree:").toString());
                do {
                    buf.append(LogFactory.objectId((org.ocpsoft.prettytime.natty.java.lang.Object)classLoader));
                    if (classLoader == systemClassLoader) {
                        buf.append((String)"org.ocpsoft.prettytime.natty. (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException ex) {
                        buf.append((String)"org.ocpsoft.prettytime.natty. --> SECRET");
                        break block9;
                    }
                    buf.append((String)"org.ocpsoft.prettytime.natty. --> ");
                } while (classLoader != null);
                buf.append((String)"org.ocpsoft.prettytime.natty.BOOT");
            }
            LogFactory.logDiagnostic(buf.toString());
        }
    }

    public static String objectId(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return "org.ocpsoft.prettytime.natty.null";
        }
        return new StringBuffer().append(o.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty.@").append(System.identityHashCode((org.ocpsoft.prettytime.natty.java.lang.Object)o)).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        factories = null;
        nullClassLoaderFactory = null;
        thisClassLoader = LogFactory.getClassLoader(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory);
        LogFactory.initDiagnostics();
        LogFactory.logClassLoaderEnvironment(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory);
        factories = LogFactory.createFactoryStore();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic((String)"org.ocpsoft.prettytime.natty.BOOTSTRAP COMPLETED");
        }
    }
}

