/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang.time;

import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Number;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Calendar;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.GregorianCalendar;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.StringUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.text.StrBuilder;

public class DurationFormatUtils
extends Object {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "org.ocpsoft.prettytime.natty.'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object y = "org.ocpsoft.prettytime.natty.y";
    static final Object M = "org.ocpsoft.prettytime.natty.M";
    static final Object d = "org.ocpsoft.prettytime.natty.d";
    static final Object H = "org.ocpsoft.prettytime.natty.H";
    static final Object m = "org.ocpsoft.prettytime.natty.m";
    static final Object s = "org.ocpsoft.prettytime.natty.s";
    static final Object S = "org.ocpsoft.prettytime.natty.S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, (String)"org.ocpsoft.prettytime.natty.H:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, (String)"org.ocpsoft.prettytime.natty.'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'", false);
    }

    public static String formatDuration(long durationMillis, String format) {
        return DurationFormatUtils.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Token[] tokens = DurationFormatUtils.lexx(format);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = (int)(durationMillis / 86400000L);
            durationMillis -= (long)days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = (int)(durationMillis / 3600000L);
            durationMillis -= (long)hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = (int)(durationMillis / 60000L);
            durationMillis -= (long)minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = (int)(durationMillis / 1000L);
            durationMillis -= (long)seconds * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, S)) {
            milliseconds = (int)durationMillis;
        }
        return DurationFormatUtils.format(tokens, 0, 0, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.formatDuration(durationMillis, (String)"org.ocpsoft.prettytime.natty.d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty. ").append(duration).toString();
            tmp = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 0 days", (String)"org.ocpsoft.prettytime.natty.");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, (String)"org.ocpsoft.prettytime.natty. 0 hours", (String)"org.ocpsoft.prettytime.natty.")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 0 minutes", (String)"org.ocpsoft.prettytime.natty.");
                if (tmp.length() != duration.length()) {
                    duration = StringUtils.replaceOnce(tmp, (String)"org.ocpsoft.prettytime.natty. 0 seconds", (String)"org.ocpsoft.prettytime.natty.");
                }
            }
            if (duration.length() != 0) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 0 seconds", (String)"org.ocpsoft.prettytime.natty.")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, (String)"org.ocpsoft.prettytime.natty. 0 minutes", (String)"org.ocpsoft.prettytime.natty.")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, (String)"org.ocpsoft.prettytime.natty. 0 hours", (String)"org.ocpsoft.prettytime.natty.")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, (String)"org.ocpsoft.prettytime.natty. 0 days", (String)"org.ocpsoft.prettytime.natty.");
        }
        duration = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty. ").append(duration).toString();
        duration = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 1 seconds", (String)"org.ocpsoft.prettytime.natty. 1 second");
        duration = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 1 minutes", (String)"org.ocpsoft.prettytime.natty. 1 minute");
        duration = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 1 hours", (String)"org.ocpsoft.prettytime.natty. 1 hour");
        duration = StringUtils.replaceOnce(duration, (String)"org.ocpsoft.prettytime.natty. 1 days", (String)"org.ocpsoft.prettytime.natty. 1 day");
        return duration.trim();
    }

    public static String formatPeriodISO(long startMillis, long endMillis) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, (String)"org.ocpsoft.prettytime.natty.'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'", false, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, format, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        Token[] tokens = DurationFormatUtils.lexx(format);
        Calendar start = Calendar.getInstance((TimeZone)timezone);
        start.setTime(new Date(startMillis));
        Calendar end = Calendar.getInstance((TimeZone)timezone);
        end.setTime(new Date(endMillis));
        int milliseconds = end.get(14) - start.get(14);
        int seconds = end.get(13) - start.get(13);
        int minutes = end.get(12) - start.get(12);
        int hours = end.get(11) - start.get(11);
        int days = end.get(5) - start.get(5);
        int months = end.get(2) - start.get(2);
        int years = end.get(1) - start.get(1);
        while (milliseconds < 0) {
            milliseconds += 1000;
            --seconds;
        }
        while (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        while (minutes < 0) {
            minutes += 60;
            --hours;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        if (Token.containsTokenWithValue(tokens, M)) {
            while (days < 0) {
                days += start.getActualMaximum(5);
                --months;
                start.add(2, 1);
            }
            while (months < 0) {
                months += 12;
                --years;
            }
            if (!Token.containsTokenWithValue(tokens, y) && years != 0) {
                while (years != 0) {
                    months += 12 * years;
                    years = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokens, y)) {
                int target = end.get(1);
                if (months < 0) {
                    --target;
                }
                while (start.get(1) != target) {
                    days += start.getActualMaximum(6) - start.get(6);
                    if (start instanceof GregorianCalendar && start.get(2) == 1 && start.get(5) == 29) {
                        ++days;
                    }
                    start.add(1, 1);
                    days += start.get(6);
                }
                years = 0;
            }
            while (start.get(2) != end.get(2)) {
                days += start.getActualMaximum(5);
                start.add(2, 1);
            }
            months = 0;
            while (days < 0) {
                days += start.getActualMaximum(5);
                --months;
                start.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours += 24 * days;
            days = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes += 60 * hours;
            hours = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds += 60 * minutes;
            minutes = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += 1000 * seconds;
            seconds = 0;
        }
        return DurationFormatUtils.format(tokens, years, months, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    static String format(Token[] tokens, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds, boolean padWithZeros) {
        StrBuilder buffer = new StrBuilder();
        boolean lastOutputSeconds = false;
        int sz = tokens.length;
        for (int i = 0; i < sz; ++i) {
            Token token = tokens[i];
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuffer) {
                buffer.append(value.toString());
                continue;
            }
            if (value == y) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)years), count, '0') : Integer.toString((int)years));
                lastOutputSeconds = false;
                continue;
            }
            if (value == M) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)months), count, '0') : Integer.toString((int)months));
                lastOutputSeconds = false;
                continue;
            }
            if (value == d) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)days), count, '0') : Integer.toString((int)days));
                lastOutputSeconds = false;
                continue;
            }
            if (value == H) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)hours), count, '0') : Integer.toString((int)hours));
                lastOutputSeconds = false;
                continue;
            }
            if (value == m) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)minutes), count, '0') : Integer.toString((int)minutes));
                lastOutputSeconds = false;
                continue;
            }
            if (value == s) {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)seconds), count, '0') : Integer.toString((int)seconds));
                lastOutputSeconds = true;
                continue;
            }
            if (value != S) continue;
            if (lastOutputSeconds) {
                String str = padWithZeros ? StringUtils.leftPad(Integer.toString((int)milliseconds), count, '0') : Integer.toString((int)(milliseconds += 1000));
                buffer.append(str.substring(1));
            } else {
                buffer.append(padWithZeros ? StringUtils.leftPad(Integer.toString((int)milliseconds), count, '0') : Integer.toString((int)milliseconds));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    static Token[] lexx(String format) {
        char[] array = format.toCharArray();
        ArrayList list = new ArrayList(array.length);
        boolean inLiteral = false;
        StringBuffer buffer = null;
        Token previous = null;
        int sz = array.length;
        for (int i = 0; i < sz; ++i) {
            char ch = array[i];
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuffer();
                    list.add((Object)new Token((Object)buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        list.add((Object)new Token((Object)buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue() == value) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add((Object)token);
                previous = token;
            }
            buffer = null;
        }
        return (Token[])list.toArray((Object[])new Token[list.size()]);
    }

    static class Token
    extends Object {
        private Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            int sz = tokens.length;
            for (int i = 0; i < sz; ++i) {
                if (tokens[i].getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        Token(Object value, int count) {
            this.value = value;
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuffer) {
                    return this.value.toString().equals((Object)tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

