/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang.text;

import org.ocpsoft.prettytime.natty.java.lang.Character;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.NumberFormatException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.text.Format;
import org.ocpsoft.prettytime.natty.java.text.MessageFormat;
import org.ocpsoft.prettytime.natty.java.text.ParsePosition;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Locale;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ObjectUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.Validate;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.text.FormatFactory;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.text.StrBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.text.StrMatcher;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "org.ocpsoft.prettytime.natty.";
    private static final String ESCAPED_QUOTE = "org.ocpsoft.prettytime.natty.''";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map registry;

    public ExtendedMessageFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public ExtendedMessageFormat(String pattern, Locale locale) {
        this(pattern, locale, null);
    }

    public ExtendedMessageFormat(String pattern, Map registry) {
        this(pattern, Locale.getDefault(), registry);
    }

    public ExtendedMessageFormat(String pattern, Locale locale, Map registry) {
        super((String)"org.ocpsoft.prettytime.natty.");
        this.setLocale(locale);
        this.registry = registry;
        this.applyPattern(pattern);
    }

    public String toPattern() {
        return this.toPattern;
    }

    public final void applyPattern(String pattern) {
        if (this.registry == null) {
            super.applyPattern(pattern);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList foundFormats = new ArrayList();
        ArrayList foundDescriptions = new ArrayList();
        StrBuilder stripCustom = new StrBuilder(pattern.length());
        ParsePosition pos = new ParsePosition(0);
        char[] c = pattern.toCharArray();
        int fmtCount = 0;
        block4: while (pos.getIndex() < pattern.length()) {
            switch (c[pos.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern, pos, stripCustom, true);
                    continue block4;
                }
                case '{': {
                    ++fmtCount;
                    this.seekNonWs(pattern, pos);
                    int start = pos.getIndex();
                    int index = this.readArgumentIndex(pattern, this.next(pos));
                    stripCustom.append('{').append(index);
                    this.seekNonWs(pattern, pos);
                    Format format = null;
                    String formatDescription = null;
                    if (c[pos.getIndex()] == ',' && (format = this.getFormat(formatDescription = this.parseFormatDescription(pattern, this.next(pos)))) == null) {
                        stripCustom.append(',').append(formatDescription);
                    }
                    foundFormats.add(format);
                    foundDescriptions.add((Object)(format == null ? null : formatDescription));
                    Validate.isTrue(foundFormats.size() == fmtCount);
                    Validate.isTrue(foundDescriptions.size() == fmtCount);
                    if (c[pos.getIndex()] == '}') break;
                    throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unreadable format element at position ").append(start).toString());
                }
            }
            stripCustom.append(c[pos.getIndex()]);
            this.next(pos);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), foundDescriptions);
        if (this.containsElements((Collection)foundFormats)) {
            Format[] origFormats = this.getFormats();
            int i = 0;
            Iterator it = foundFormats.iterator();
            while (it.hasNext()) {
                Format f = (Format)it.next();
                if (f != null) {
                    origFormats[i] = f;
                }
                ++i;
            }
            super.setFormats(origFormats);
        }
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getClass(), (Object)obj.getClass())) {
            return false;
        }
        ExtendedMessageFormat rhs = (ExtendedMessageFormat)obj;
        if (ObjectUtils.notEqual((Object)this.toPattern, (Object)rhs.toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual((Object)this.registry, (Object)rhs.registry);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.hashCode((Object)this.registry);
        result = 31 * result + ObjectUtils.hashCode((Object)this.toPattern);
        return result;
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory;
            String name = desc;
            String args = null;
            int i = desc.indexOf(44);
            if (i > 0) {
                name = desc.substring(0, i).trim();
                args = desc.substring(i + 1).trim();
            }
            if ((factory = (FormatFactory)this.registry.get((Object)name)) != null) {
                return factory.getFormat(name, args, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StrBuilder();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace((char)c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt((String)result.toString());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                error = Character.isDigit((char)c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid format argument index at position ").append(start).append((String)"org.ocpsoft.prettytime.natty.: ").append(pattern.substring(start, pos.getIndex())).toString());
        }
        throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unterminated format element at position ").append(start).toString());
    }

    private String parseFormatDescription(String pattern, ParsePosition pos) {
        int start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        int text = pos.getIndex();
        int depth = 1;
        while (pos.getIndex() < pattern.length()) {
            switch (pattern.charAt(pos.getIndex())) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth != 0) break;
                    return pattern.substring(text, pos.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern, pos, false);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unterminated format element at position ").append(start).toString());
    }

    private String insertFormats(String pattern, ArrayList customPatterns) {
        if (!this.containsElements((Collection)customPatterns)) {
            return pattern;
        }
        StrBuilder sb = new StrBuilder(pattern.length() * 2);
        ParsePosition pos = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        block5: while (pos.getIndex() < pattern.length()) {
            char c = pattern.charAt(pos.getIndex());
            switch (c) {
                case '\'': {
                    this.appendQuotedString(pattern, pos, sb, false);
                    break;
                }
                case '{': {
                    String customPattern;
                    if (++depth != 1) continue block5;
                    sb.append('{').append(this.readArgumentIndex(pattern, this.next(pos)));
                    if ((customPattern = (String)customPatterns.get(++fe)) == null) continue block5;
                    sb.append(',').append(customPattern);
                    break;
                }
                case '}': {
                    --depth;
                }
                default: {
                    sb.append(c);
                    this.next(pos);
                }
            }
        }
        return sb.toString();
    }

    private void seekNonWs(String pattern, ParsePosition pos) {
        int len = 0;
        char[] buffer = pattern.toCharArray();
        do {
            len = StrMatcher.splitMatcher().isMatch(buffer, pos.getIndex());
            pos.setIndex(pos.getIndex() + len);
        } while (len > 0 && pos.getIndex() < pattern.length());
    }

    private ParsePosition next(ParsePosition pos) {
        pos.setIndex(pos.getIndex() + 1);
        return pos;
    }

    private StrBuilder appendQuotedString(String pattern, ParsePosition pos, StrBuilder appendTo, boolean escapingOn) {
        int start = pos.getIndex();
        char[] c = pattern.toCharArray();
        if (escapingOn && c[start] == '\'') {
            this.next(pos);
            return appendTo == null ? null : appendTo.append('\'');
        }
        int lastHold = start;
        for (int i = pos.getIndex(); i < pattern.length(); ++i) {
            if (escapingOn && pattern.substring(i).startsWith((String)"org.ocpsoft.prettytime.natty.''")) {
                appendTo.append(c, lastHold, pos.getIndex() - lastHold).append('\'');
                pos.setIndex(i + "org.ocpsoft.prettytime.natty.''".length());
                lastHold = pos.getIndex();
                continue;
            }
            switch (c[pos.getIndex()]) {
                case '\'': {
                    this.next(pos);
                    return appendTo == null ? null : appendTo.append(c, lastHold, pos.getIndex() - lastHold);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unterminated quoted string at position ").append(start).toString());
    }

    private void getQuotedString(String pattern, ParsePosition pos, boolean escapingOn) {
        this.appendQuotedString(pattern, pos, null, escapingOn);
    }

    private boolean containsElements(Collection coll) {
        if (coll == null || coll.size() == 0) {
            return false;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return true;
        }
        return false;
    }
}

