/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang.reflect;

import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.IllegalAccessException;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.reflect.AccessibleObject;
import org.ocpsoft.prettytime.natty.java.lang.reflect.InvocationTargetException;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Member;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Method;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Modifier;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ArrayUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ClassUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.reflect.MemberUtils;

public class MethodUtils
extends Object {
    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No such accessible method: ").append(methodName).append((String)"org.ocpsoft.prettytime.natty.() on object: ").append(object.getClass().getName()).toString());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No such accessible method: ").append(methodName).append((String)"org.ocpsoft.prettytime.natty.() on object: ").append(object.getClass().getName()).toString());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No such accessible method: ").append(methodName).append((String)"org.ocpsoft.prettytime.natty.() on class: ").append(cls.getName()).toString());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeStaticMethod(cls, methodName, new Object[]{arg});
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.No such accessible method: ").append(methodName).append((String)"org.ocpsoft.prettytime.natty.() on class: ").append(cls.getName()).toString());
        }
        return method.invoke(null, args);
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactStaticMethod(cls, methodName, new Object[]{arg});
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Method getAccessibleMethod(Class cls, String methodName, Class parameterType) {
        return MethodUtils.getAccessibleMethod(cls, methodName, new Class[]{parameterType});
    }

    public static Method getAccessibleMethod(Class cls, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class[] parameterTypes;
        if (!MemberUtils.isAccessible((Member)method)) {
            return null;
        }
        Class cls = method.getDeclaringClass();
        if (Modifier.isPublic((int)cls.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(cls, methodName, parameterTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class cls, String methodName, Class[] parameterTypes) {
        for (Class parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!Modifier.isPublic((int)parentClass.getModifiers())) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class cls, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (cls != null) {
            Class[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic((int)interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
            }
            cls = cls.getSuperclass();
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class cls, String methodName, Class[] parameterTypes) {
        try {
            Method method = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround((AccessibleObject)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            Method bestMatch = null;
            Method[] methods = cls.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Method accessibleMethod;
                if (!methods[i].getName().equals((Object)methodName) || !ClassUtils.isAssignable(parameterTypes, methods[i].getParameterTypes(), true) || (accessibleMethod = MethodUtils.getAccessibleMethod(methods[i])) == null || bestMatch != null && MemberUtils.compareParameterTypes(accessibleMethod.getParameterTypes(), bestMatch.getParameterTypes(), parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (bestMatch != null) {
                MemberUtils.setAccessibleWorkaround(bestMatch);
            }
            return bestMatch;
        }
    }
}

