/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang;

import org.ocpsoft.prettytime.natty.java.io.File;
import org.ocpsoft.prettytime.natty.java.lang.Boolean;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Float;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ArrayUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.StringUtils;

public class SystemUtils
extends Object {
    private static final int JAVA_VERSION_TRIM_SIZE = 3;
    private static final String OS_NAME_WINDOWS_PREFIX = "org.ocpsoft.prettytime.natty.Windows";
    private static final String USER_HOME_KEY = "org.ocpsoft.prettytime.natty.user.home";
    private static final String USER_DIR_KEY = "org.ocpsoft.prettytime.natty.user.dir";
    private static final String JAVA_IO_TMPDIR_KEY = "org.ocpsoft.prettytime.natty.java.io.tmpdir";
    private static final String JAVA_HOME_KEY = "org.ocpsoft.prettytime.natty.java.home";
    public static final String AWT_TOOLKIT = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.awt.toolkit");
    public static final String FILE_ENCODING = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.file.encoding");
    public static final String FILE_SEPARATOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.file.separator");
    public static final String JAVA_AWT_FONTS = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.awt.fonts");
    public static final String JAVA_AWT_GRAPHICSENV = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.awt.graphicsenv");
    public static final String JAVA_AWT_HEADLESS = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.awt.headless");
    public static final String JAVA_AWT_PRINTERJOB = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.awt.printerjob");
    public static final String JAVA_CLASS_PATH = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.class.path");
    public static final String JAVA_CLASS_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.class.version");
    public static final String JAVA_COMPILER = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.compiler");
    public static final String JAVA_ENDORSED_DIRS = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.endorsed.dirs");
    public static final String JAVA_EXT_DIRS = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.ext.dirs");
    public static final String JAVA_HOME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.home");
    public static final String JAVA_IO_TMPDIR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.library.path");
    public static final String JAVA_RUNTIME_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.runtime.name");
    public static final String JAVA_RUNTIME_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.runtime.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.specification.name");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.specification.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.specification.version");
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.util.prefs.PreferencesFactory");
    public static final String JAVA_VENDOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vendor");
    public static final String JAVA_VENDOR_URL = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vendor.url");
    public static final String JAVA_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.version");
    public static final String JAVA_VM_INFO = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.info");
    public static final String JAVA_VM_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.specification.version");
    public static final String JAVA_VM_VENDOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.vendor");
    public static final String JAVA_VM_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.java.vm.version");
    public static final String LINE_SEPARATOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.line.separator");
    public static final String OS_ARCH = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.os.arch");
    public static final String OS_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.os.name");
    public static final String OS_VERSION = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.os.version");
    public static final String PATH_SEPARATOR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.path.separator");
    public static final String USER_COUNTRY = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.country") == null ? SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.region") : SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.country");
    public static final String USER_DIR = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.dir");
    public static final String USER_HOME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.home");
    public static final String USER_LANGUAGE = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.language");
    public static final String USER_NAME = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.name");
    public static final String USER_TIMEZONE = SystemUtils.getSystemProperty((String)"org.ocpsoft.prettytime.natty.user.timezone");
    public static final String JAVA_VERSION_TRIMMED = SystemUtils.getJavaVersionTrimmed();
    public static final float JAVA_VERSION_FLOAT = SystemUtils.getJavaVersionAsFloat();
    public static final int JAVA_VERSION_INT = SystemUtils.getJavaVersionAsInt();
    public static final boolean IS_JAVA_1_1 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.1");
    public static final boolean IS_JAVA_1_2 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.2");
    public static final boolean IS_JAVA_1_3 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.3");
    public static final boolean IS_JAVA_1_4 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.4");
    public static final boolean IS_JAVA_1_5 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.5");
    public static final boolean IS_JAVA_1_6 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.6");
    public static final boolean IS_JAVA_1_7 = SystemUtils.getJavaVersionMatches((String)"org.ocpsoft.prettytime.natty.1.7");
    public static final boolean IS_OS_AIX = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.AIX");
    public static final boolean IS_OS_HP_UX = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.HP-UX");
    public static final boolean IS_OS_IRIX = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Irix");
    public static final boolean IS_OS_LINUX = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Linux") || SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Mac");
    public static final boolean IS_OS_MAC_OSX = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Mac OS X");
    public static final boolean IS_OS_OS2 = SystemUtils.getOSMatchesName((String)"org/ocpsoft/prettytime/natty/OS/2");
    public static final boolean IS_OS_SOLARIS = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Solaris");
    public static final boolean IS_OS_SUN_OS = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.SunOS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS;
    public static final boolean IS_OS_WINDOWS = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows", (String)"org.ocpsoft.prettytime.natty.5.0");
    public static final boolean IS_OS_WINDOWS_95 = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows 9", (String)"org.ocpsoft.prettytime.natty.4.0");
    public static final boolean IS_OS_WINDOWS_98 = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows 9", (String)"org.ocpsoft.prettytime.natty.4.1");
    public static final boolean IS_OS_WINDOWS_ME = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows", (String)"org.ocpsoft.prettytime.natty.4.9");
    public static final boolean IS_OS_WINDOWS_NT = SystemUtils.getOSMatchesName((String)"org.ocpsoft.prettytime.natty.Windows NT");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows", (String)"org.ocpsoft.prettytime.natty.5.1");
    public static final boolean IS_OS_WINDOWS_VISTA = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows", (String)"org.ocpsoft.prettytime.natty.6.0");
    public static final boolean IS_OS_WINDOWS_7 = SystemUtils.getOSMatches((String)"org.ocpsoft.prettytime.natty.Windows", (String)"org.ocpsoft.prettytime.natty.6.1");

    public static File getJavaHome() {
        return new File(System.getProperty((String)"org.ocpsoft.prettytime.natty.java.home"));
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty((String)"org.ocpsoft.prettytime.natty.java.io.tmpdir"));
    }

    public static float getJavaVersion() {
        return JAVA_VERSION_FLOAT;
    }

    private static float getJavaVersionAsFloat() {
        return SystemUtils.toVersionFloat(SystemUtils.toJavaVersionIntArray(JAVA_VERSION, 3));
    }

    private static int getJavaVersionAsInt() {
        return SystemUtils.toVersionInt(SystemUtils.toJavaVersionIntArray(JAVA_VERSION, 3));
    }

    private static boolean getJavaVersionMatches(String versionPrefix) {
        return SystemUtils.isJavaVersionMatch(JAVA_VERSION_TRIMMED, versionPrefix);
    }

    private static String getJavaVersionTrimmed() {
        if (JAVA_VERSION != null) {
            for (int i = 0; i < JAVA_VERSION.length(); ++i) {
                char ch = JAVA_VERSION.charAt(i);
                if (ch < '0' || ch > '9') continue;
                return JAVA_VERSION.substring(i);
            }
        }
        return null;
    }

    private static boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
        return SystemUtils.isOSMatch(OS_NAME, OS_VERSION, osNamePrefix, osVersionPrefix);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        return SystemUtils.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty((String)property);
        }
        catch (SecurityException ex) {
            System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Caught a SecurityException reading the system property '").append(property).append((String)"org.ocpsoft.prettytime.natty.'; the SystemUtils property value will default to null.").toString());
            return null;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty((String)"org.ocpsoft.prettytime.natty.user.dir"));
    }

    public static File getUserHome() {
        return new File(System.getProperty((String)"org.ocpsoft.prettytime.natty.user.home"));
    }

    public static boolean isJavaAwtHeadless() {
        return JAVA_AWT_HEADLESS != null ? JAVA_AWT_HEADLESS.equals((Object)Boolean.TRUE.toString()) : false;
    }

    public static boolean isJavaVersionAtLeast(float requiredVersion) {
        return JAVA_VERSION_FLOAT >= requiredVersion;
    }

    public static boolean isJavaVersionAtLeast(int requiredVersion) {
        return JAVA_VERSION_INT >= requiredVersion;
    }

    static boolean isJavaVersionMatch(String version, String versionPrefix) {
        if (version == null) {
            return false;
        }
        return version.startsWith(versionPrefix);
    }

    static boolean isOSMatch(String osName, String osVersion, String osNamePrefix, String osVersionPrefix) {
        if (osName == null || osVersion == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix) && osVersion.startsWith(osVersionPrefix);
    }

    static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    static float toJavaVersionFloat(String version) {
        return SystemUtils.toVersionFloat(SystemUtils.toJavaVersionIntArray(version, 3));
    }

    static int toJavaVersionInt(String version) {
        return SystemUtils.toVersionInt(SystemUtils.toJavaVersionIntArray(version, 3));
    }

    static int[] toJavaVersionIntArray(String version) {
        return SystemUtils.toJavaVersionIntArray(version, java.lang.Integer.MAX_VALUE);
    }

    private static int[] toJavaVersionIntArray(String version, int limit) {
        if (version == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String[] strings = StringUtils.split(version, (String)"org.ocpsoft.prettytime.natty.._- ");
        int[] ints = new int[Math.min((int)limit, (int)strings.length)];
        int j = 0;
        for (int i = 0; i < strings.length && j < limit; ++i) {
            String s = strings[i];
            if (s.length() <= 0) continue;
            try {
                ints[j] = Integer.parseInt((String)s);
                ++j;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (ints.length > j) {
            int[] newInts = new int[j];
            System.arraycopy((Object)ints, (int)0, (Object)newInts, (int)0, (int)j);
            ints = newInts;
        }
        return ints;
    }

    private static float toVersionFloat(int[] javaVersions) {
        if (javaVersions == null || javaVersions.length == 0) {
            return 0.0f;
        }
        if (javaVersions.length == 1) {
            return javaVersions[0];
        }
        StringBuffer builder = new StringBuffer();
        builder.append(javaVersions[0]);
        builder.append('.');
        for (int i = 1; i < javaVersions.length; ++i) {
            builder.append(javaVersions[i]);
        }
        try {
            return Float.parseFloat((String)builder.toString());
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    private static int toVersionInt(int[] javaVersions) {
        if (javaVersions == null) {
            return 0;
        }
        int intVersion = 0;
        int len = javaVersions.length;
        if (len >= 1) {
            intVersion = javaVersions[0] * 100;
        }
        if (len >= 2) {
            intVersion += javaVersions[1] * 10;
        }
        if (len >= 3) {
            intVersion += javaVersions[2];
        }
        return intVersion;
    }
}

