/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.Cloneable;
import org.ocpsoft.prettytime.natty.java.lang.Comparable;
import org.ocpsoft.prettytime.natty.java.lang.IllegalAccessException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Array;
import org.ocpsoft.prettytime.natty.java.lang.reflect.InvocationTargetException;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.exception.CloneFailedException;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.reflect.MethodUtils;

public class ObjectUtils
extends Object {
    public static final Null NULL = new Null();

    public static Object defaultIfNull(Object object, Object defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static boolean notEqual(Object object1, Object object2) {
        return !ObjectUtils.equals(object1, object2);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        ObjectUtils.identityToString(buffer, object);
        return buffer.toString();
    }

    public static void identityToString(StringBuffer buffer, Object object) {
        if (object == null) {
            throw new NullPointerException((String)"org.ocpsoft.prettytime.natty.Cannot get the toString of a null identity");
        }
        buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString((int)System.identityHashCode((Object)object)));
    }

    public static StringBuffer appendIdentityToString(StringBuffer buffer, Object object) {
        if (object == null) {
            return null;
        }
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        return buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString((int)System.identityHashCode((Object)object)));
    }

    public static String toString(Object obj) {
        return obj == null ? "org.ocpsoft.prettytime.natty." : obj.toString();
    }

    public static String toString(Object obj, String nullStr) {
        return obj == null ? nullStr : obj.toString();
    }

    public static Object min(Comparable c1, Comparable c2) {
        return ObjectUtils.compare(c1, c2, true) <= 0 ? c1 : c2;
    }

    public static Object max(Comparable c1, Comparable c2) {
        return ObjectUtils.compare(c1, c2, false) >= 0 ? c1 : c2;
    }

    public static int compare(Comparable c1, Comparable c2) {
        return ObjectUtils.compare(c1, c2, false);
    }

    public static int compare(Comparable c1, Comparable c2, boolean nullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return nullGreater ? 1 : -1;
        }
        if (c2 == null) {
            return nullGreater ? -1 : 1;
        }
        return c1.compareTo((Object)c2);
    }

    public static Object clone(Object o) {
        if (o instanceof Cloneable) {
            Object result;
            if (o.getClass().isArray()) {
                Class componentType = o.getClass().getComponentType();
                if (!componentType.isPrimitive()) {
                    result = ((Object[])o).clone();
                } else {
                    int length = Array.getLength((Object)o);
                    result = Array.newInstance((Class)componentType, (int)length);
                    while (length-- > 0) {
                        Array.set((Object)result, (int)length, (Object)Array.get((Object)o, (int)length));
                    }
                }
            } else {
                try {
                    result = MethodUtils.invokeMethod(o, (String)"org.ocpsoft.prettytime.natty.clone", null);
                }
                catch (NoSuchMethodException e) {
                    throw new CloneFailedException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Cloneable type ").append(o.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty. has no clone method").toString(), (Throwable)((java.lang.Object)e));
                }
                catch (IllegalAccessException e) {
                    throw new CloneFailedException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Cannot clone Cloneable type ").append(o.getClass().getName()).toString(), (Throwable)((java.lang.Object)e));
                }
                catch (InvocationTargetException e) {
                    throw new CloneFailedException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Exception cloning Cloneable type ").append(o.getClass().getName()).toString(), e.getTargetException());
                }
            }
            return result;
        }
        return null;
    }

    public static Object cloneIfPossible(Object o) {
        Object clone = ObjectUtils.clone(o);
        return clone == null ? o : clone;
    }

    public static class Null
    extends Object
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

