/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang;

import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Arrays;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Collections;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.HashSet;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.Locale;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.Set;

public class LocaleUtils
extends Object {
    private static List cAvailableLocaleList;
    private static Set cAvailableLocaleSet;
    private static final Map cLanguagesByCountry;
    private static final Map cCountriesByLanguage;

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid locale format: ").append(str).toString());
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid locale format: ").append(str).toString());
        }
        if (len == 2) {
            return new Locale(str, (String)"org.ocpsoft.prettytime.natty.");
        }
        if (str.charAt(2) != '_') {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid locale format: ").append(str).toString());
        }
        char ch3 = str.charAt(3);
        if (ch3 == '_') {
            return new Locale(str.substring(0, 2), (String)"org.ocpsoft.prettytime.natty.", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid locale format: ").append(str).toString());
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid locale format: ").append(str).toString());
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    public static List localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List localeLookupList(Locale locale, Locale defaultLocale) {
        ArrayList list = new ArrayList(4);
        if (locale != null) {
            list.add((Object)locale);
            if (locale.getVariant().length() > 0) {
                list.add((Object)new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                list.add((Object)new Locale(locale.getLanguage(), (String)"org.ocpsoft.prettytime.natty."));
            }
            if (!list.contains((Object)defaultLocale)) {
                list.add((Object)defaultLocale);
            }
        }
        return Collections.unmodifiableList((List)list);
    }

    public static List availableLocaleList() {
        if (cAvailableLocaleList == null) {
            LocaleUtils.initAvailableLocaleList();
        }
        return cAvailableLocaleList;
    }

    private static synchronized void initAvailableLocaleList() {
        if (cAvailableLocaleList == null) {
            List list = Arrays.asList((Object[])Locale.getAvailableLocales());
            cAvailableLocaleList = Collections.unmodifiableList((List)list);
        }
    }

    public static Set availableLocaleSet() {
        if (cAvailableLocaleSet == null) {
            LocaleUtils.initAvailableLocaleSet();
        }
        return cAvailableLocaleSet;
    }

    private static synchronized void initAvailableLocaleSet() {
        if (cAvailableLocaleSet == null) {
            cAvailableLocaleSet = Collections.unmodifiableSet((Set)new HashSet((Collection)LocaleUtils.availableLocaleList()));
        }
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains((Object)locale);
    }

    public static List languagesByCountry(String countryCode) {
        List langs = (List)cLanguagesByCountry.get((Object)countryCode);
        if (langs == null) {
            if (countryCode != null) {
                langs = new ArrayList();
                List locales = LocaleUtils.availableLocaleList();
                for (int i = 0; i < locales.size(); ++i) {
                    Locale locale = (Locale)locales.get(i);
                    if (!countryCode.equals((Object)locale.getCountry()) || locale.getVariant().length() != 0) continue;
                    langs.add((Object)locale);
                }
                langs = Collections.unmodifiableList((List)langs);
            } else {
                langs = Collections.EMPTY_LIST;
            }
            cLanguagesByCountry.put((Object)countryCode, (Object)langs);
        }
        return langs;
    }

    public static List countriesByLanguage(String languageCode) {
        List countries = (List)cCountriesByLanguage.get((Object)languageCode);
        if (countries == null) {
            if (languageCode != null) {
                countries = new ArrayList();
                List locales = LocaleUtils.availableLocaleList();
                for (int i = 0; i < locales.size(); ++i) {
                    Locale locale = (Locale)locales.get(i);
                    if (!languageCode.equals((Object)locale.getLanguage()) || locale.getCountry().length() == 0 || locale.getVariant().length() != 0) continue;
                    countries.add((Object)locale);
                }
                countries = Collections.unmodifiableList((List)countries);
            } else {
                countries = Collections.EMPTY_LIST;
            }
            cCountriesByLanguage.put((Object)languageCode, (Object)countries);
        }
        return countries;
    }

    static {
        cLanguagesByCountry = Collections.synchronizedMap((Map)new HashMap());
        cCountriesByLanguage = Collections.synchronizedMap((Map)new HashMap());
    }
}

