/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang;

import org.ocpsoft.prettytime.natty.java.lang.Boolean;
import org.ocpsoft.prettytime.natty.java.lang.Byte;
import org.ocpsoft.prettytime.natty.java.lang.Character;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassLoader;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Double;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Float;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Long;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NoSuchMethodException;
import org.ocpsoft.prettytime.natty.java.lang.SecurityException;
import org.ocpsoft.prettytime.natty.java.lang.Short;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.lang.Void;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Method;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Modifier;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ArrayUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.NullArgumentException;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.StringUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.text.StrBuilder;

public class ClassUtils
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf((char)'.');
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf((char)'$');
    private static final Map primitiveWrapperMap = new HashMap();
    private static final Map wrapperPrimitiveMap;
    private static final Map abbreviationMap;
    private static final Map reverseAbbreviationMap;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$apache$commons$lang$ClassUtils;

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)primitive, (org.ocpsoft.prettytime.natty.java.lang.Object)abbreviation);
        reverseAbbreviationMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)abbreviation, (org.ocpsoft.prettytime.natty.java.lang.Object)primitive);
    }

    public static String getShortClassName(org.ocpsoft.prettytime.natty.java.lang.Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        int lastDotIdx;
        if (className == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        if (className.length() == 0) {
            return "org.ocpsoft.prettytime.natty.";
        }
        StrBuilder arrayPrefix = new StrBuilder();
        if (className.startsWith((String)"org.ocpsoft.prettytime.natty.[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append((String)"org.ocpsoft.prettytime.natty.[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey((org.ocpsoft.prettytime.natty.java.lang.Object)className)) {
            className = (String)reverseAbbreviationMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)className);
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return new StringBuffer().append(out).append((org.ocpsoft.prettytime.natty.java.lang.Object)arrayPrefix).toString();
    }

    public static String getPackageName(org.ocpsoft.prettytime.natty.java.lang.Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageName(object.getClass());
    }

    public static String getPackageName(Class cls) {
        if (cls == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return ClassUtils.getPackageName(cls.getName());
    }

    public static String getPackageName(String className) {
        int i;
        if (className == null || className.length() == 0) {
            return "org.ocpsoft.prettytime.natty.";
        }
        while (className.charAt(0) == '[') {
            className = className.substring(1);
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            className = className.substring(1);
        }
        if ((i = className.lastIndexOf(46)) == -1) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return className.substring(0, i);
    }

    public static List getAllSuperclasses(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add((org.ocpsoft.prettytime.natty.java.lang.Object)superclass);
        }
        return classes;
    }

    public static List getAllInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList interfacesFound = new ArrayList();
        ClassUtils.getAllInterfaces(cls, (List)interfacesFound);
        return interfacesFound;
    }

    private static void getAllInterfaces(Class cls, List interfacesFound) {
        while (cls != null) {
            Class[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfacesFound.contains((org.ocpsoft.prettytime.natty.java.lang.Object)interfaces[i])) continue;
                interfacesFound.add((org.ocpsoft.prettytime.natty.java.lang.Object)interfaces[i]);
                ClassUtils.getAllInterfaces(interfaces[i], interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static List convertClassNamesToClasses(List classNames) {
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList(classNames.size());
        Iterator it = classNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            try {
                classes.add((org.ocpsoft.prettytime.natty.java.lang.Object)Class.forName((String)className));
            }
            catch (Exception ex) {
                classes.add(null);
            }
        }
        return classes;
    }

    public static List convertClassesToClassNames(List classes) {
        if (classes == null) {
            return null;
        }
        ArrayList classNames = new ArrayList(classes.size());
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class cls = (Class)it.next();
            if (cls == null) {
                classNames.add(null);
                continue;
            }
            classNames.add((org.ocpsoft.prettytime.natty.java.lang.Object)cls.getName());
        }
        return classNames;
    }

    public static boolean isAssignable(Class[] classArray, Class[] toClassArray) {
        return ClassUtils.isAssignable(classArray, toClassArray, false);
    }

    public static boolean isAssignable(Class[] classArray, Class[] toClassArray, boolean autoboxing) {
        if (!ArrayUtils.isSameLength((org.ocpsoft.prettytime.natty.java.lang.Object[])classArray, (org.ocpsoft.prettytime.natty.java.lang.Object[])toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ClassUtils.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class cls, Class toClass) {
        return ClassUtils.isAssignable(cls, toClass, false);
    }

    public static boolean isAssignable(Class cls, Class toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Long.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            if (Long.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            if (Boolean.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return false;
            }
            if (Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return false;
            }
            if (Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            if (Character.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Integer.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Long.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            if (Short.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Integer.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Long.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            if (Byte.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)cls)) {
                return Short.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Integer.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Long.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Float.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass) || Double.TYPE.equals((org.ocpsoft.prettytime.natty.java.lang.Object)toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class primitiveToWrapper(Class cls) {
        Class convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = (Class)primitiveWrapperMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)cls);
        }
        return convertedClass;
    }

    public static Class[] primitivesToWrappers(Class[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.primitiveToWrapper(classes[i]);
        }
        return convertedClasses;
    }

    public static Class wrapperToPrimitive(Class cls) {
        return (Class)wrapperPrimitiveMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)cls);
    }

    public static Class[] wrappersToPrimitives(Class[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.wrapperToPrimitive(classes[i]);
        }
        return convertedClasses;
    }

    public static boolean isInnerClass(Class cls) {
        if (cls == null) {
            return false;
        }
        return cls.getName().indexOf(36) >= 0;
    }

    public static Class getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class clazz;
            if (abbreviationMap.containsKey((org.ocpsoft.prettytime.natty.java.lang.Object)className)) {
                String clsName = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[").append(abbreviationMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)className)).toString();
                clazz = Class.forName((String)clsName, (boolean)initialize, (ClassLoader)classLoader).getComponentType();
            } else {
                clazz = Class.forName((String)ClassUtils.toCanonicalName(className), (boolean)initialize, (ClassLoader)classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ClassUtils.getClass(classLoader, new StringBuffer().append(className.substring(0, lastDotIndex)).append('$').append(className.substring(lastDotIndex + 1)).toString(), initialize);
                }
                catch (ClassNotFoundException ex2) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, className, true);
    }

    public static Class getClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className, true);
    }

    public static Class getClass(String className, boolean initialize) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? (class$org$apache$commons$lang$ClassUtils == null ? (class$org$apache$commons$lang$ClassUtils = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.org.apache.commons.lang.ClassUtils")) : class$org$apache$commons$lang$ClassUtils).getClassLoader() : contextCL;
        return ClassUtils.getClass(loader, className, initialize);
    }

    public static Method getPublicMethod(Class cls, String methodName, Class[] parameterTypes) throws SecurityException, NoSuchMethodException {
        Method declaredMethod = cls.getMethod(methodName, parameterTypes);
        if (Modifier.isPublic((int)declaredMethod.getDeclaringClass().getModifiers())) {
            return declaredMethod;
        }
        ArrayList candidateClasses = new ArrayList();
        candidateClasses.addAll((Collection)ClassUtils.getAllInterfaces(cls));
        candidateClasses.addAll((Collection)ClassUtils.getAllSuperclasses(cls));
        Iterator it = candidateClasses.iterator();
        while (it.hasNext()) {
            Method candidateMethod;
            Class candidateClass = (Class)it.next();
            if (!Modifier.isPublic((int)candidateClass.getModifiers())) continue;
            try {
                candidateMethod = candidateClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            if (!Modifier.isPublic((int)candidateMethod.getDeclaringClass().getModifiers())) continue;
            return candidateMethod;
        }
        throw new NoSuchMethodException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Can't find a public method for ").append(methodName).append((String)"org.ocpsoft.prettytime.natty. ").append(ArrayUtils.toString((org.ocpsoft.prettytime.natty.java.lang.Object)parameterTypes)).toString());
    }

    private static String toCanonicalName(String className) {
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            throw new NullArgumentException((String)"org.ocpsoft.prettytime.natty.className");
        }
        if (className.endsWith((String)"org.ocpsoft.prettytime.natty.[]")) {
            StrBuilder classNameBuffer = new StrBuilder();
            while (className.endsWith((String)"org.ocpsoft.prettytime.natty.[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append((String)"org.ocpsoft.prettytime.natty.[");
            }
            String abbreviation = (String)abbreviationMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append((String)"org.ocpsoft.prettytime.natty.L").append(className).append((String)"org.ocpsoft.prettytime.natty.;");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    public static Class[] toClass(org.ocpsoft.prettytime.natty.java.lang.Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            classes[i] = array[i] == null ? null : array[i].getClass();
        }
        return classes;
    }

    public static String getShortCanonicalName(org.ocpsoft.prettytime.natty.java.lang.Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortCanonicalName(object.getClass().getName());
    }

    public static String getShortCanonicalName(Class cls) {
        if (cls == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return ClassUtils.getShortCanonicalName(cls.getName());
    }

    public static String getShortCanonicalName(String canonicalName) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(canonicalName));
    }

    public static String getPackageCanonicalName(org.ocpsoft.prettytime.natty.java.lang.Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageCanonicalName(object.getClass().getName());
    }

    public static String getPackageCanonicalName(Class cls) {
        if (cls == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return ClassUtils.getPackageCanonicalName(cls.getName());
    }

    public static String getPackageCanonicalName(String canonicalName) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(canonicalName));
    }

    private static String getCanonicalName(String className) {
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            return null;
        }
        int dim = 0;
        while (className.startsWith((String)"org.ocpsoft.prettytime.natty.[")) {
            ++dim;
            className = className.substring(1);
        }
        if (dim < 1) {
            return className;
        }
        if (className.startsWith((String)"org.ocpsoft.prettytime.natty.L")) {
            className = className.substring(1, className.endsWith((String)"org.ocpsoft.prettytime.natty.;") ? className.length() - 1 : className.length());
        } else if (className.length() > 0) {
            className = (String)reverseAbbreviationMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)className.substring(0, 1));
        }
        StrBuilder canonicalClassNameBuffer = new StrBuilder(className);
        for (int i = 0; i < dim; ++i) {
            canonicalClassNameBuffer.append((String)"org.ocpsoft.prettytime.natty.[]");
        }
        return canonicalClassNameBuffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Boolean.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Boolean")) : class$java$lang$Boolean));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Byte.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Byte")) : class$java$lang$Byte));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Character.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Character")) : class$java$lang$Character));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Short.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Short")) : class$java$lang$Short));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Integer.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Integer")) : class$java$lang$Integer));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Long.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Long")) : class$java$lang$Long));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Double.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Double")) : class$java$lang$Double));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Float.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)(class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$((String)"org.ocpsoft.prettytime.natty.java.lang.Float")) : class$java$lang$Float));
        primitiveWrapperMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)Void.TYPE, (org.ocpsoft.prettytime.natty.java.lang.Object)Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        Iterator it = primitiveWrapperMap.keySet().iterator();
        while (it.hasNext()) {
            Class wrapperClass;
            Class primitiveClass = (Class)it.next();
            if (primitiveClass.equals((org.ocpsoft.prettytime.natty.java.lang.Object)(wrapperClass = (Class)primitiveWrapperMap.get((org.ocpsoft.prettytime.natty.java.lang.Object)primitiveClass)))) continue;
            wrapperPrimitiveMap.put((org.ocpsoft.prettytime.natty.java.lang.Object)wrapperClass, (org.ocpsoft.prettytime.natty.java.lang.Object)primitiveClass);
        }
        abbreviationMap = new HashMap();
        reverseAbbreviationMap = new HashMap();
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.int", (String)"org.ocpsoft.prettytime.natty.I");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.boolean", (String)"org.ocpsoft.prettytime.natty.Z");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.float", (String)"org.ocpsoft.prettytime.natty.F");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.long", (String)"org.ocpsoft.prettytime.natty.J");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.short", (String)"org.ocpsoft.prettytime.natty.S");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.byte", (String)"org.ocpsoft.prettytime.natty.B");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.double", (String)"org.ocpsoft.prettytime.natty.D");
        ClassUtils.addAbbreviation((String)"org.ocpsoft.prettytime.natty.char", (String)"org.ocpsoft.prettytime.natty.C");
    }
}

