/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.lang;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.util.Collections;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.HashSet;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.Set;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.CharRange;

public class CharSet
extends Object
implements Serializable {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final CharSet EMPTY = new CharSet((String)null);
    public static final CharSet ASCII_ALPHA = new CharSet((String)"org.ocpsoft.prettytime.natty.a-zA-Z");
    public static final CharSet ASCII_ALPHA_LOWER = new CharSet((String)"org.ocpsoft.prettytime.natty.a-z");
    public static final CharSet ASCII_ALPHA_UPPER = new CharSet((String)"org.ocpsoft.prettytime.natty.A-Z");
    public static final CharSet ASCII_NUMERIC = new CharSet((String)"org.ocpsoft.prettytime.natty.0-9");
    protected static final Map COMMON = Collections.synchronizedMap((Map)new HashMap());
    private final Set set = Collections.synchronizedSet((Set)new HashSet());

    public static CharSet getInstance(String setStr) {
        Object set = COMMON.get((Object)setStr);
        if (set != null) {
            return (CharSet)set;
        }
        return new CharSet(setStr);
    }

    public static CharSet getInstance(String[] setStrs) {
        if (setStrs == null) {
            return null;
        }
        return new CharSet(setStrs);
    }

    protected CharSet(String setStr) {
        this.add(setStr);
    }

    protected CharSet(String[] set) {
        int sz = set.length;
        for (int i = 0; i < sz; ++i) {
            this.add(set[i]);
        }
    }

    protected void add(String str) {
        if (str == null) {
            return;
        }
        int len = str.length();
        int pos = 0;
        while (pos < len) {
            int remainder = len - pos;
            if (remainder >= 4 && str.charAt(pos) == '^' && str.charAt(pos + 2) == '-') {
                this.set.add((Object)CharRange.isNotIn(str.charAt(pos + 1), str.charAt(pos + 3)));
                pos += 4;
                continue;
            }
            if (remainder >= 3 && str.charAt(pos + 1) == '-') {
                this.set.add((Object)CharRange.isIn(str.charAt(pos), str.charAt(pos + 2)));
                pos += 3;
                continue;
            }
            if (remainder >= 2 && str.charAt(pos) == '^') {
                this.set.add((Object)CharRange.isNot(str.charAt(pos + 1)));
                pos += 2;
                continue;
            }
            this.set.add((Object)CharRange.is(str.charAt(pos)));
            ++pos;
        }
    }

    public CharRange[] getCharRanges() {
        return (CharRange[])this.set.toArray((Object[])new CharRange[this.set.size()]);
    }

    public boolean contains(char ch) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            CharRange range = (CharRange)it.next();
            if (!range.contains(ch)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet other = (CharSet)obj;
        return this.set.equals((Object)other.set);
    }

    public int hashCode() {
        return 89 + this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }

    static {
        COMMON.put(null, (Object)EMPTY);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.", (Object)EMPTY);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.a-zA-Z", (Object)ASCII_ALPHA);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.A-Za-z", (Object)ASCII_ALPHA);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.a-z", (Object)ASCII_ALPHA_LOWER);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.A-Z", (Object)ASCII_ALPHA_UPPER);
        COMMON.put((Object)"org.ocpsoft.prettytime.natty.0-9", (Object)ASCII_NUMERIC);
    }
}

