/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.net;

import org.ocpsoft.prettytime.natty.java.io.UnsupportedEncodingException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.DecoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.binary.StringUtils;

abstract class RFC1522Codec
extends Object {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "org.ocpsoft.prettytime.natty.?=";
    protected static final String PREFIX = "org.ocpsoft.prettytime.natty.=?";

    RFC1522Codec() {
    }

    protected String encodeText(String text, String charset) throws EncoderException, UnsupportedEncodingException {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append((String)"org.ocpsoft.prettytime.natty.=?");
        buffer.append(charset);
        buffer.append('?');
        buffer.append(this.getEncoding());
        buffer.append('?');
        byte[] rawdata = this.doEncoding(text.getBytes(charset));
        buffer.append(StringUtils.newStringUsAscii(rawdata));
        buffer.append((String)"org.ocpsoft.prettytime.natty.?=");
        return buffer.toString();
    }

    protected String decodeText(String text) throws DecoderException, UnsupportedEncodingException {
        if (text == null) {
            return null;
        }
        if (!text.startsWith((String)"org.ocpsoft.prettytime.natty.=?") || !text.endsWith((String)"org.ocpsoft.prettytime.natty.?=")) {
            throw new DecoderException((String)"org.ocpsoft.prettytime.natty.RFC 1522 violation: malformed encoded content");
        }
        int terminator = text.length() - 2;
        int from = 2;
        int to = text.indexOf(63, from);
        if (to == terminator) {
            throw new DecoderException((String)"org.ocpsoft.prettytime.natty.RFC 1522 violation: charset token not found");
        }
        String charset = text.substring(from, to);
        if (charset.equals((Object)"org.ocpsoft.prettytime.natty.")) {
            throw new DecoderException((String)"org.ocpsoft.prettytime.natty.RFC 1522 violation: charset not specified");
        }
        from = to + 1;
        if ((to = text.indexOf(63, from)) == terminator) {
            throw new DecoderException((String)"org.ocpsoft.prettytime.natty.RFC 1522 violation: encoding token not found");
        }
        String encoding = text.substring(from, to);
        if (!this.getEncoding().equalsIgnoreCase(encoding)) {
            throw new DecoderException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.This codec cannot decode ").append(encoding).append((String)"org.ocpsoft.prettytime.natty. encoded content").toString());
        }
        from = to + 1;
        to = text.indexOf(63, from);
        byte[] data = StringUtils.getBytesUsAscii(text.substring(from, to));
        data = this.doDecoding(data);
        return new String(data, charset);
    }

    protected abstract String getEncoding();

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;
}

