/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.net;

import org.ocpsoft.prettytime.natty.java.io.ByteArrayOutputStream;
import org.ocpsoft.prettytime.natty.java.io.UnsupportedEncodingException;
import org.ocpsoft.prettytime.natty.java.lang.ArrayIndexOutOfBoundsException;
import org.ocpsoft.prettytime.natty.java.lang.Character;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.BitSet;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.BinaryDecoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.BinaryEncoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.DecoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.StringDecoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.StringEncoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.binary.StringUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
extends Object
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    private final String charset;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;

    public QuotedPrintableCodec() {
        this((String)"org.ocpsoft.prettytime.natty.UTF-8");
    }

    public QuotedPrintableCodec(String charset) {
        this.charset = charset;
    }

    private static final void encodeQuotedPrintable(int b, ByteArrayOutputStream buffer) {
        buffer.write(61);
        char hex1 = Character.toUpperCase((char)Character.forDigit((int)(b >> 4 & 0xF), (int)16));
        char hex2 = Character.toUpperCase((char)Character.forDigit((int)(b & 0xF), (int)16));
        buffer.write((int)hex1);
        buffer.write((int)hex2);
    }

    public static final byte[] encodeQuotedPrintable(BitSet printable, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (printable == null) {
            printable = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (printable.get(b)) {
                buffer.write(b);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(b, buffer);
        }
        return buffer.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 61) {
                try {
                    int u = Utils.digit16(bytes[++i]);
                    int l = Utils.digit16(bytes[++i]);
                    buffer.write((int)((char)((u << 4) + l)));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException((String)"org.ocpsoft.prettytime.natty.Invalid quoted-printable encoding", (Throwable)((java.lang.Object)e));
                }
            }
            buffer.write((int)b);
        }
        return buffer.toByteArray();
    }

    public byte[] encode(byte[] bytes) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, bytes);
    }

    public byte[] decode(byte[] bytes) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(bytes);
    }

    public String encode(String pString) throws EncoderException {
        if (pString == null) {
            return null;
        }
        try {
            return this.encode(pString, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
    }

    public String decode(String pString, String charset) throws DecoderException, UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(pString)), charset);
    }

    public String decode(String pString) throws DecoderException {
        if (pString == null) {
            return null;
        }
        try {
            return this.decode(pString, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
    }

    public Object encode(Object pObject) throws EncoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.encode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.encode((String)pObject);
        }
        throw new EncoderException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Objects of type ").append(pObject.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty. cannot be quoted-printable encoded").toString());
    }

    public Object decode(Object pObject) throws DecoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.decode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.decode((String)pObject);
        }
        throw new DecoderException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Objects of type ").append(pObject.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty. cannot be quoted-printable decoded").toString());
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    public String encode(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(pString.getBytes(charset)));
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

