/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.language;

import org.ocpsoft.prettytime.natty.java.lang.Character;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.StringEncoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.language.SoundexUtils;

public class RefinedSoundex
extends Object
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "org.ocpsoft.prettytime.natty.01360240043788015936020505";
    private static final char[] US_ENGLISH_MAPPING = "org.ocpsoft.prettytime.natty.01360240043788015936020505".toCharArray();
    private final char[] soundexMapping;
    public static final RefinedSoundex US_ENGLISH = new RefinedSoundex();

    public RefinedSoundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    public RefinedSoundex(char[] mapping) {
        this.soundexMapping = new char[mapping.length];
        System.arraycopy((Object)mapping, (int)0, (Object)this.soundexMapping, (int)0, (int)mapping.length);
    }

    public RefinedSoundex(String mapping) {
        this.soundexMapping = mapping.toCharArray();
    }

    public int difference(String s1, String s2) throws EncoderException {
        return SoundexUtils.difference(this, s1, s2);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException((String)"org.ocpsoft.prettytime.natty.Parameter supplied to RefinedSoundex encode is not of type java.lang.String");
        }
        return this.soundex((String)pObject);
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    char getMappingCode(char c) {
        if (!Character.isLetter((char)c)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase((char)c) - 65];
    }

    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append(str.charAt(0));
        char last = '*';
        for (int i = 0; i < str.length(); ++i) {
            char current = this.getMappingCode(str.charAt(i));
            if (current == last) continue;
            if (current != '\u0000') {
                sBuf.append(current);
            }
            last = current;
        }
        return sBuf.toString();
    }
}

