/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.language;

import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.Locale;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.StringEncoder;

public class DoubleMetaphone
extends Object
implements StringEncoder {
    private static final String VOWELS = "org.ocpsoft.prettytime.natty.AEIOUY";
    private static final String[] SILENT_START = new String[]{"org.ocpsoft.prettytime.natty.GN", "org.ocpsoft.prettytime.natty.KN", "org.ocpsoft.prettytime.natty.PN", "org.ocpsoft.prettytime.natty.WR", "org.ocpsoft.prettytime.natty.PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"org.ocpsoft.prettytime.natty.L", "org.ocpsoft.prettytime.natty.R", "org.ocpsoft.prettytime.natty.N", "org.ocpsoft.prettytime.natty.M", "org.ocpsoft.prettytime.natty.B", "org.ocpsoft.prettytime.natty.H", "org.ocpsoft.prettytime.natty.F", "org.ocpsoft.prettytime.natty.V", "org.ocpsoft.prettytime.natty.W", "org.ocpsoft.prettytime.natty. "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"org.ocpsoft.prettytime.natty.ES", "org.ocpsoft.prettytime.natty.EP", "org.ocpsoft.prettytime.natty.EB", "org.ocpsoft.prettytime.natty.EL", "org.ocpsoft.prettytime.natty.EY", "org.ocpsoft.prettytime.natty.IB", "org.ocpsoft.prettytime.natty.IL", "org.ocpsoft.prettytime.natty.IN", "org.ocpsoft.prettytime.natty.IE", "org.ocpsoft.prettytime.natty.EI", "org.ocpsoft.prettytime.natty.ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"org.ocpsoft.prettytime.natty.L", "org.ocpsoft.prettytime.natty.T", "org.ocpsoft.prettytime.natty.K", "org.ocpsoft.prettytime.natty.S", "org.ocpsoft.prettytime.natty.N", "org.ocpsoft.prettytime.natty.M", "org.ocpsoft.prettytime.natty.B", "org.ocpsoft.prettytime.natty.Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String value) {
        return this.doubleMetaphone(value, false);
    }

    public String doubleMetaphone(String value, boolean alternate) {
        if ((value = this.cleanInput(value)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value);
        int index = this.isSilentStart(value) ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this.getMaxCodeLen());
        block25: while (!result.isComplete() && index <= value.length() - 1) {
            switch (value.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index = this.handleAEIOUY(result, index);
                    continue block25;
                }
                case 'B': {
                    result.append('P');
                    index = this.charAt(value, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result.append('S');
                    ++index;
                    continue block25;
                }
                case 'C': {
                    index = this.handleC(value, result, index);
                    continue block25;
                }
                case 'D': {
                    index = this.handleD(value, result, index);
                    continue block25;
                }
                case 'F': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'G': {
                    index = this.handleG(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index = this.handleH(value, result, index);
                    continue block25;
                }
                case 'J': {
                    index = this.handleJ(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'L': {
                    index = this.handleL(value, result, index);
                    continue block25;
                }
                case 'M': {
                    result.append('M');
                    index = this.conditionM0(value, index) ? index + 2 : index + 1;
                    continue block25;
                }
                case 'N': {
                    result.append('N');
                    index = this.charAt(value, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result.append('N');
                    ++index;
                    continue block25;
                }
                case 'P': {
                    index = this.handleP(value, result, index);
                    continue block25;
                }
                case 'Q': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'R': {
                    index = this.handleR(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index = this.handleS(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index = this.handleT(value, result, index);
                    continue block25;
                }
                case 'V': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'W': {
                    index = this.handleW(value, result, index);
                    continue block25;
                }
                case 'X': {
                    index = this.handleX(value, result, index);
                    continue block25;
                }
                case 'Z': {
                    index = this.handleZ(value, result, index, slavoGermanic);
                    continue block25;
                }
            }
            ++index;
        }
        return alternate ? result.getAlternate() : result.getPrimary();
    }

    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException((String)"org.ocpsoft.prettytime.natty.DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)obj);
    }

    public String encode(String value) {
        return this.doubleMetaphone(value);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        return this.isDoubleMetaphoneEqual(value1, value2, false);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        return this.doubleMetaphone(value1, alternate).equals((Object)this.doubleMetaphone(value2, alternate));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    private int handleAEIOUY(DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('A');
        }
        return index + 1;
    }

    private int handleC(String value, DoubleMetaphoneResult result, int index) {
        if (this.conditionC0(value, index)) {
            result.append('K');
            index += 2;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 6, (String)"org.ocpsoft.prettytime.natty.CAESAR")) {
            result.append('S');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.CH")) {
            index = this.handleCH(value, result, index);
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.CZ") && !DoubleMetaphone.contains(value, index - 2, 4, (String)"org.ocpsoft.prettytime.natty.WICZ")) {
            result.append('S', 'X');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 3, (String)"org.ocpsoft.prettytime.natty.CIA")) {
            result.append('X');
            index += 3;
        } else {
            if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.CC") && (index != 1 || this.charAt(value, 0) != 'M')) {
                return this.handleCC(value, result, index);
            }
            if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.CK", (String)"org.ocpsoft.prettytime.natty.CG", (String)"org.ocpsoft.prettytime.natty.CQ")) {
                result.append('K');
                index += 2;
            } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.CI", (String)"org.ocpsoft.prettytime.natty.CE", (String)"org.ocpsoft.prettytime.natty.CY")) {
                if (DoubleMetaphone.contains(value, index, 3, (String)"org.ocpsoft.prettytime.natty.CIO", (String)"org.ocpsoft.prettytime.natty.CIE", (String)"org.ocpsoft.prettytime.natty.CIA")) {
                    result.append('S', 'X');
                } else {
                    result.append('S');
                }
                index += 2;
            } else {
                result.append('K');
                index = DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty. C", (String)"org.ocpsoft.prettytime.natty. Q", (String)"org.ocpsoft.prettytime.natty. G") ? (index += 3) : (DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.C", (String)"org.ocpsoft.prettytime.natty.K", (String)"org.ocpsoft.prettytime.natty.Q") && !DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty.CE", (String)"org.ocpsoft.prettytime.natty.CI") ? (index += 2) : ++index);
            }
        }
        return index;
    }

    private int handleCC(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index + 2, 1, (String)"org.ocpsoft.prettytime.natty.I", (String)"org.ocpsoft.prettytime.natty.E", (String)"org.ocpsoft.prettytime.natty.H") && !DoubleMetaphone.contains(value, index + 2, 2, (String)"org.ocpsoft.prettytime.natty.HU")) {
            if (index == 1 && this.charAt(value, index - 1) == 'A' || DoubleMetaphone.contains(value, index - 1, 5, (String)"org.ocpsoft.prettytime.natty.UCCEE", (String)"org.ocpsoft.prettytime.natty.UCCES")) {
                result.append((String)"org.ocpsoft.prettytime.natty.KS");
            } else {
                result.append('X');
            }
            index += 3;
        } else {
            result.append('K');
            index += 2;
        }
        return index;
    }

    private int handleCH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.CHAE")) {
            result.append('K', 'X');
            return index + 2;
        }
        if (this.conditionCH0(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (index > 0) {
            if (DoubleMetaphone.contains(value, 0, 2, (String)"org.ocpsoft.prettytime.natty.MC")) {
                result.append('K');
            } else {
                result.append('X', 'K');
            }
        } else {
            result.append('X');
        }
        return index + 2;
    }

    private int handleD(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.DG")) {
            if (DoubleMetaphone.contains(value, index + 2, 1, (String)"org.ocpsoft.prettytime.natty.I", (String)"org.ocpsoft.prettytime.natty.E", (String)"org.ocpsoft.prettytime.natty.Y")) {
                result.append('J');
                index += 3;
            } else {
                result.append((String)"org.ocpsoft.prettytime.natty.TK");
                index += 2;
            }
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.DT", (String)"org.ocpsoft.prettytime.natty.DD")) {
            result.append('T');
            index += 2;
        } else {
            result.append('T');
            ++index;
        }
        return index;
    }

    private int handleG(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            index = this.handleGH(value, result, index);
        } else if (this.charAt(value, index + 1) == 'N') {
            if (index == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result.append((String)"org.ocpsoft.prettytime.natty.KN", (String)"org.ocpsoft.prettytime.natty.N");
            } else if (!DoubleMetaphone.contains(value, index + 2, 2, (String)"org.ocpsoft.prettytime.natty.EY") && this.charAt(value, index + 1) != 'Y' && !slavoGermanic) {
                result.append((String)"org.ocpsoft.prettytime.natty.N", (String)"org.ocpsoft.prettytime.natty.KN");
            } else {
                result.append((String)"org.ocpsoft.prettytime.natty.KN");
            }
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty.LI") && !slavoGermanic) {
            result.append((String)"org.ocpsoft.prettytime.natty.KL", (String)"org.ocpsoft.prettytime.natty.L");
            index += 2;
        } else if (index == 0 && (this.charAt(value, index + 1) == 'Y' || DoubleMetaphone.contains(value, index + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            result.append('K', 'J');
            index += 2;
        } else if (!(!DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty.ER") && this.charAt(value, index + 1) != 'Y' || DoubleMetaphone.contains(value, 0, 6, (String)"org.ocpsoft.prettytime.natty.DANGER", (String)"org.ocpsoft.prettytime.natty.RANGER", (String)"org.ocpsoft.prettytime.natty.MANGER") || DoubleMetaphone.contains(value, index - 1, 1, (String)"org.ocpsoft.prettytime.natty.E", (String)"org.ocpsoft.prettytime.natty.I") || DoubleMetaphone.contains(value, index - 1, 3, (String)"org.ocpsoft.prettytime.natty.RGY", (String)"org.ocpsoft.prettytime.natty.OGY"))) {
            result.append('K', 'J');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.E", (String)"org.ocpsoft.prettytime.natty.I", (String)"org.ocpsoft.prettytime.natty.Y") || DoubleMetaphone.contains(value, index - 1, 4, (String)"org.ocpsoft.prettytime.natty.AGGI", (String)"org.ocpsoft.prettytime.natty.OGGI")) {
            if (DoubleMetaphone.contains(value, 0, 4, (String)"org.ocpsoft.prettytime.natty.VAN ", (String)"org.ocpsoft.prettytime.natty.VON ") || DoubleMetaphone.contains(value, 0, 3, (String)"org.ocpsoft.prettytime.natty.SCH") || DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty.ET")) {
                result.append('K');
            } else if (DoubleMetaphone.contains(value, index + 1, 3, (String)"org.ocpsoft.prettytime.natty.IER")) {
                result.append('J');
            } else {
                result.append('J', 'K');
            }
            index += 2;
        } else if (this.charAt(value, index + 1) == 'G') {
            index += 2;
            result.append('K');
        } else {
            ++index;
            result.append('K');
        }
        return index;
    }

    private int handleGH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && !this.isVowel(this.charAt(value, index - 1))) {
            result.append('K');
            index += 2;
        } else if (index == 0) {
            if (this.charAt(value, index + 2) == 'I') {
                result.append('J');
            } else {
                result.append('K');
            }
            index += 2;
        } else if (index > 1 && DoubleMetaphone.contains(value, index - 2, 1, (String)"org.ocpsoft.prettytime.natty.B", (String)"org.ocpsoft.prettytime.natty.H", (String)"org.ocpsoft.prettytime.natty.D") || index > 2 && DoubleMetaphone.contains(value, index - 3, 1, (String)"org.ocpsoft.prettytime.natty.B", (String)"org.ocpsoft.prettytime.natty.H", (String)"org.ocpsoft.prettytime.natty.D") || index > 3 && DoubleMetaphone.contains(value, index - 4, 1, (String)"org.ocpsoft.prettytime.natty.B", (String)"org.ocpsoft.prettytime.natty.H")) {
            index += 2;
        } else {
            if (index > 2 && this.charAt(value, index - 1) == 'U' && DoubleMetaphone.contains(value, index - 3, 1, (String)"org.ocpsoft.prettytime.natty.C", (String)"org.ocpsoft.prettytime.natty.G", (String)"org.ocpsoft.prettytime.natty.L", (String)"org.ocpsoft.prettytime.natty.R", (String)"org.ocpsoft.prettytime.natty.T")) {
                result.append('F');
            } else if (index > 0 && this.charAt(value, index - 1) != 'I') {
                result.append('K');
            }
            index += 2;
        }
        return index;
    }

    private int handleH(String value, DoubleMetaphoneResult result, int index) {
        if ((index == 0 || this.isVowel(this.charAt(value, index - 1))) && this.isVowel(this.charAt(value, index + 1))) {
            result.append('H');
            index += 2;
        } else {
            ++index;
        }
        return index;
    }

    private int handleJ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.JOSE") || DoubleMetaphone.contains(value, 0, 4, (String)"org.ocpsoft.prettytime.natty.SAN ")) {
            if (index == 0 && this.charAt(value, index + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains(value, 0, 4, (String)"org.ocpsoft.prettytime.natty.SAN ")) {
                result.append('H');
            } else {
                result.append('J', 'H');
            }
            ++index;
        } else {
            if (index == 0 && !DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.JOSE")) {
                result.append('J', 'A');
            } else if (this.isVowel(this.charAt(value, index - 1)) && !slavoGermanic && (this.charAt(value, index + 1) == 'A' || this.charAt(value, index + 1) == 'O')) {
                result.append('J', 'H');
            } else if (index == value.length() - 1) {
                result.append('J', ' ');
            } else if (!DoubleMetaphone.contains(value, index + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value, index - 1, 1, (String)"org.ocpsoft.prettytime.natty.S", (String)"org.ocpsoft.prettytime.natty.K", (String)"org.ocpsoft.prettytime.natty.L")) {
                result.append('J');
            }
            index = this.charAt(value, index + 1) == 'J' ? (index += 2) : ++index;
        }
        return index;
    }

    private int handleL(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'L') {
            if (this.conditionL0(value, index)) {
                result.appendPrimary('L');
            } else {
                result.append('L');
            }
            index += 2;
        } else {
            ++index;
            result.append('L');
        }
        return index;
    }

    private int handleP(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('F');
            index += 2;
        } else {
            result.append('P');
            index = DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.P", (String)"org.ocpsoft.prettytime.natty.B") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleR(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value, index - 2, 2, (String)"org.ocpsoft.prettytime.natty.IE") && !DoubleMetaphone.contains(value, index - 4, 2, (String)"org.ocpsoft.prettytime.natty.ME", (String)"org.ocpsoft.prettytime.natty.MA")) {
            result.appendAlternate('R');
        } else {
            result.append('R');
        }
        return this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
    }

    private int handleS(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index - 1, 3, (String)"org.ocpsoft.prettytime.natty.ISL", (String)"org.ocpsoft.prettytime.natty.YSL")) {
            ++index;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 5, (String)"org.ocpsoft.prettytime.natty.SUGAR")) {
            result.append('X', 'S');
            ++index;
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.SH")) {
            if (DoubleMetaphone.contains(value, index + 1, 4, (String)"org.ocpsoft.prettytime.natty.HEIM", (String)"org.ocpsoft.prettytime.natty.HOEK", (String)"org.ocpsoft.prettytime.natty.HOLM", (String)"org.ocpsoft.prettytime.natty.HOLZ")) {
                result.append('S');
            } else {
                result.append('X');
            }
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 3, (String)"org.ocpsoft.prettytime.natty.SIO", (String)"org.ocpsoft.prettytime.natty.SIA") || DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.SIAN")) {
            if (slavoGermanic) {
                result.append('S');
            } else {
                result.append('S', 'X');
            }
            index += 3;
        } else if (index == 0 && DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.M", (String)"org.ocpsoft.prettytime.natty.N", (String)"org.ocpsoft.prettytime.natty.L", (String)"org.ocpsoft.prettytime.natty.W") || DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.Z")) {
            result.append('S', 'X');
            index = DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.Z") ? index + 2 : index + 1;
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.SC")) {
            index = this.handleSC(value, result, index);
        } else {
            if (index == value.length() - 1 && DoubleMetaphone.contains(value, index - 2, 2, (String)"org.ocpsoft.prettytime.natty.AI", (String)"org.ocpsoft.prettytime.natty.OI")) {
                result.appendAlternate('S');
            } else {
                result.append('S');
            }
            index = DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.S", (String)"org.ocpsoft.prettytime.natty.Z") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleSC(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 2) == 'H') {
            if (DoubleMetaphone.contains(value, index + 3, 2, (String)"org.ocpsoft.prettytime.natty.OO", (String)"org.ocpsoft.prettytime.natty.ER", (String)"org.ocpsoft.prettytime.natty.EN", (String)"org.ocpsoft.prettytime.natty.UY", (String)"org.ocpsoft.prettytime.natty.ED", (String)"org.ocpsoft.prettytime.natty.EM")) {
                if (DoubleMetaphone.contains(value, index + 3, 2, (String)"org.ocpsoft.prettytime.natty.ER", (String)"org.ocpsoft.prettytime.natty.EN")) {
                    result.append((String)"org.ocpsoft.prettytime.natty.X", (String)"org.ocpsoft.prettytime.natty.SK");
                } else {
                    result.append((String)"org.ocpsoft.prettytime.natty.SK");
                }
            } else if (index == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result.append('X', 'S');
            } else {
                result.append('X');
            }
        } else if (DoubleMetaphone.contains(value, index + 2, 1, (String)"org.ocpsoft.prettytime.natty.I", (String)"org.ocpsoft.prettytime.natty.E", (String)"org.ocpsoft.prettytime.natty.Y")) {
            result.append('S');
        } else {
            result.append((String)"org.ocpsoft.prettytime.natty.SK");
        }
        return index + 3;
    }

    private int handleT(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.TION")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 3, (String)"org.ocpsoft.prettytime.natty.TIA", (String)"org.ocpsoft.prettytime.natty.TCH")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.TH") || DoubleMetaphone.contains(value, index, 3, (String)"org.ocpsoft.prettytime.natty.TTH")) {
            if (DoubleMetaphone.contains(value, index + 2, 2, (String)"org.ocpsoft.prettytime.natty.OM", (String)"org.ocpsoft.prettytime.natty.AM") || DoubleMetaphone.contains(value, 0, 4, (String)"org.ocpsoft.prettytime.natty.VAN ", (String)"org.ocpsoft.prettytime.natty.VON ") || DoubleMetaphone.contains(value, 0, 3, (String)"org.ocpsoft.prettytime.natty.SCH")) {
                result.append('T');
            } else {
                result.append('0', 'T');
            }
            index += 2;
        } else {
            result.append('T');
            index = DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.T", (String)"org.ocpsoft.prettytime.natty.D") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleW(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.WR")) {
            result.append('R');
            index += 2;
        } else if (index == 0 && (this.isVowel(this.charAt(value, index + 1)) || DoubleMetaphone.contains(value, index, 2, (String)"org.ocpsoft.prettytime.natty.WH"))) {
            if (this.isVowel(this.charAt(value, index + 1))) {
                result.append('A', 'F');
            } else {
                result.append('A');
            }
            ++index;
        } else if (index == value.length() - 1 && this.isVowel(this.charAt(value, index - 1)) || DoubleMetaphone.contains(value, index - 1, 5, (String)"org.ocpsoft.prettytime.natty.EWSKI", (String)"org.ocpsoft.prettytime.natty.EWSKY", (String)"org.ocpsoft.prettytime.natty.OWSKI", (String)"org.ocpsoft.prettytime.natty.OWSKY") || DoubleMetaphone.contains(value, 0, 3, (String)"org.ocpsoft.prettytime.natty.SCH")) {
            result.appendAlternate('F');
            ++index;
        } else if (DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.WICZ", (String)"org.ocpsoft.prettytime.natty.WITZ")) {
            result.append((String)"org.ocpsoft.prettytime.natty.TS", (String)"org.ocpsoft.prettytime.natty.FX");
            index += 4;
        } else {
            ++index;
        }
        return index;
    }

    private int handleX(String value, DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('S');
            ++index;
        } else {
            if (index != value.length() - 1 || !DoubleMetaphone.contains(value, index - 3, 3, (String)"org.ocpsoft.prettytime.natty.IAU", (String)"org.ocpsoft.prettytime.natty.EAU") && !DoubleMetaphone.contains(value, index - 2, 2, (String)"org.ocpsoft.prettytime.natty.AU", (String)"org.ocpsoft.prettytime.natty.OU")) {
                result.append((String)"org.ocpsoft.prettytime.natty.KS");
            }
            index = DoubleMetaphone.contains(value, index + 1, 1, (String)"org.ocpsoft.prettytime.natty.C", (String)"org.ocpsoft.prettytime.natty.X") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleZ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('J');
            index += 2;
        } else {
            if (DoubleMetaphone.contains(value, index + 1, 2, (String)"org.ocpsoft.prettytime.natty.ZO", (String)"org.ocpsoft.prettytime.natty.ZI", (String)"org.ocpsoft.prettytime.natty.ZA") || slavoGermanic && index > 0 && this.charAt(value, index - 1) != 'T') {
                result.append((String)"org.ocpsoft.prettytime.natty.S", (String)"org.ocpsoft.prettytime.natty.TS");
            } else {
                result.append('S');
            }
            index = this.charAt(value, index + 1) == 'Z' ? index + 2 : index + 1;
        }
        return index;
    }

    private boolean conditionC0(String value, int index) {
        if (DoubleMetaphone.contains(value, index, 4, (String)"org.ocpsoft.prettytime.natty.CHIA")) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index - 1, 3, (String)"org.ocpsoft.prettytime.natty.ACH")) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.contains(value, index - 2, 6, (String)"org.ocpsoft.prettytime.natty.BACHER", (String)"org.ocpsoft.prettytime.natty.MACHER");
    }

    private boolean conditionCH0(String value, int index) {
        if (index != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index + 1, 5, (String)"org.ocpsoft.prettytime.natty.HARAC", (String)"org.ocpsoft.prettytime.natty.HARIS") && !DoubleMetaphone.contains(value, index + 1, 3, (String)"org.ocpsoft.prettytime.natty.HOR", (String)"org.ocpsoft.prettytime.natty.HYM", (String)"org.ocpsoft.prettytime.natty.HIA", (String)"org.ocpsoft.prettytime.natty.HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(value, 0, 5, (String)"org.ocpsoft.prettytime.natty.CHORE");
    }

    private boolean conditionCH1(String value, int index) {
        return DoubleMetaphone.contains(value, 0, 4, (String)"org.ocpsoft.prettytime.natty.VAN ", (String)"org.ocpsoft.prettytime.natty.VON ") || DoubleMetaphone.contains(value, 0, 3, (String)"org.ocpsoft.prettytime.natty.SCH") || DoubleMetaphone.contains(value, index - 2, 6, (String)"org.ocpsoft.prettytime.natty.ORCHES", (String)"org.ocpsoft.prettytime.natty.ARCHIT", (String)"org.ocpsoft.prettytime.natty.ORCHID") || DoubleMetaphone.contains(value, index + 2, 1, (String)"org.ocpsoft.prettytime.natty.T", (String)"org.ocpsoft.prettytime.natty.S") || (DoubleMetaphone.contains(value, index - 1, 1, (String)"org.ocpsoft.prettytime.natty.A", (String)"org.ocpsoft.prettytime.natty.O", (String)"org.ocpsoft.prettytime.natty.U", (String)"org.ocpsoft.prettytime.natty.E") || index == 0) && (DoubleMetaphone.contains(value, index + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || index + 1 == value.length() - 1);
    }

    private boolean conditionL0(String value, int index) {
        if (index == value.length() - 3 && DoubleMetaphone.contains(value, index - 1, 4, (String)"org.ocpsoft.prettytime.natty.ILLO", (String)"org.ocpsoft.prettytime.natty.ILLA", (String)"org.ocpsoft.prettytime.natty.ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(value, value.length() - 2, 2, (String)"org.ocpsoft.prettytime.natty.AS", (String)"org.ocpsoft.prettytime.natty.OS") || DoubleMetaphone.contains(value, value.length() - 1, 1, (String)"org.ocpsoft.prettytime.natty.A", (String)"org.ocpsoft.prettytime.natty.O")) && DoubleMetaphone.contains(value, index - 1, 4, (String)"org.ocpsoft.prettytime.natty.ALLE");
    }

    private boolean conditionM0(String value, int index) {
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(value, index - 1, 3, (String)"org.ocpsoft.prettytime.natty.UMB") && (index + 1 == value.length() - 1 || DoubleMetaphone.contains(value, index + 2, 2, (String)"org.ocpsoft.prettytime.natty.ER"));
    }

    private boolean isSlavoGermanic(String value) {
        return value.indexOf(87) > -1 || value.indexOf(75) > -1 || value.indexOf((String)"org.ocpsoft.prettytime.natty.CZ") > -1 || value.indexOf((String)"org.ocpsoft.prettytime.natty.WITZ") > -1;
    }

    private boolean isVowel(char ch) {
        return "org.ocpsoft.prettytime.natty.AEIOUY".indexOf((int)ch) != -1;
    }

    private boolean isSilentStart(String value) {
        boolean result = false;
        for (int i = 0; i < SILENT_START.length; ++i) {
            if (!value.startsWith(SILENT_START[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    private String cleanInput(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String value, int index) {
        if (index < 0 || index >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index);
    }

    private static boolean contains(String value, int start, int length, String criteria) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria});
    }

    private static boolean contains(String value, int start, int length, String criteria1, String criteria2) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria1, criteria2});
    }

    private static boolean contains(String value, int start, int length, String criteria1, String criteria2, String criteria3) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria1, criteria2, criteria3});
    }

    private static boolean contains(String value, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria1, criteria2, criteria3, criteria4});
    }

    private static boolean contains(String value, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4, String criteria5) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria1, criteria2, criteria3, criteria4, criteria5});
    }

    private static boolean contains(String value, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4, String criteria5, String criteria6) {
        return DoubleMetaphone.contains(value, start, length, new String[]{criteria1, criteria2, criteria3, criteria4, criteria5, criteria6});
    }

    protected static boolean contains(String value, int start, int length, String[] criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            String target = value.substring(start, start + length);
            for (int i = 0; i < criteria.length; ++i) {
                if (!target.equals((Object)criteria[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public class DoubleMetaphoneResult
    extends Object {
        private StringBuffer primary;
        private StringBuffer alternate;
        private int maxLength;

        public DoubleMetaphoneResult(int maxLength) {
            this.primary = new StringBuffer(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuffer(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = maxLength;
        }

        public void append(char value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(char primary, char alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(char value) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value);
            }
        }

        public void appendAlternate(char value) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value);
            }
        }

        public void append(String value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(String primary, String alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(String value) {
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                this.primary.append(value);
            } else {
                this.primary.append(value.substring(0, addChars));
            }
        }

        public void appendAlternate(String value) {
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                this.alternate.append(value);
            } else {
                this.alternate.append(value.substring(0, addChars));
            }
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

