/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.language;

import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.Locale;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.StringEncoder;

public class ColognePhonetic
extends Object
implements StringEncoder {
    private static final char[][] PREPROCESS_MAP = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};
    static /* synthetic */ Class class$java$lang$String;

    private static boolean arrayContains(char[] arr, char key) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != key) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String text) {
        if (text == null) {
            return null;
        }
        text = this.preprocess(text);
        CologneOutputBuffer output = new CologneOutputBuffer(text.length() * 2);
        CologneInputBuffer input = new CologneInputBuffer(text.toCharArray());
        char lastChar = '-';
        int lastCode = 47;
        int rightLength = input.length();
        while (rightLength > 0) {
            int code;
            char chr = input.removeNext();
            rightLength = input.length();
            char nextChar = rightLength > 0 ? (char)input.getNextChar() : (char)'-';
            if (ColognePhonetic.arrayContains(new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'}, chr)) {
                code = 48;
            } else if (chr == 'H' || chr < 'A' || chr > 'Z') {
                if (lastCode == 47) continue;
                code = 45;
            } else if (chr == 'B' || chr == 'P' && nextChar != 'H') {
                code = 49;
            } else if (!(chr != 'D' && chr != 'T' || ColognePhonetic.arrayContains(new char[]{'S', 'C', 'Z'}, nextChar))) {
                code = 50;
            } else if (ColognePhonetic.arrayContains(new char[]{'W', 'F', 'P', 'V'}, chr)) {
                code = 51;
            } else if (ColognePhonetic.arrayContains(new char[]{'G', 'K', 'Q'}, chr)) {
                code = 52;
            } else if (chr == 'X' && !ColognePhonetic.arrayContains(new char[]{'C', 'K', 'Q'}, lastChar)) {
                code = 52;
                input.addLeft('S');
                ++rightLength;
            } else {
                code = chr == 'S' || chr == 'Z' ? 56 : (chr == 'C' ? (lastCode == 47 ? (ColognePhonetic.arrayContains(new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'}, nextChar) ? 52 : 56) : (ColognePhonetic.arrayContains(new char[]{'S', 'Z'}, lastChar) || !ColognePhonetic.arrayContains(new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'}, nextChar) ? 56 : 52)) : (ColognePhonetic.arrayContains(new char[]{'T', 'D', 'X'}, chr) ? 56 : (chr == 'R' ? 55 : (chr == 'L' ? 53 : (chr == 'M' || chr == 'N' ? 54 : (int)chr)))));
            }
            if (code != 45 && (lastCode != code && (code != 48 || lastCode == 47) || code < 48 || code > 56)) {
                output.addRight((char)code);
            }
            lastChar = chr;
            lastCode = code;
        }
        return output.toString();
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.This method\u2019s parameter was expected to be of the type ").append((class$java$lang$String == null ? (class$java$lang$String = ColognePhonetic.class$((String)"org.ocpsoft.prettytime.natty.java.lang.String")) : class$java$lang$String).getName()).append((String)"org.ocpsoft.prettytime.natty.. But actually it was of the type ").append(object.getClass().getName()).append((String)"org.ocpsoft.prettytime.natty..").toString());
        }
        return this.encode((String)object);
    }

    public String encode(String text) {
        return this.colognePhonetic(text);
    }

    public boolean isEncodeEqual(String text1, String text2) {
        return this.colognePhonetic(text1).equals((Object)this.colognePhonetic(text2));
    }

    private String preprocess(String text) {
        text = text.toUpperCase(Locale.GERMAN);
        char[] chrs = text.toCharArray();
        block0: for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] <= 'Z') continue;
            for (int replacement = 0; replacement < PREPROCESS_MAP.length; ++replacement) {
                if (chrs[index] != PREPROCESS_MAP[replacement][0]) continue;
                chrs[index] = PREPROCESS_MAP[replacement][1];
                continue block0;
            }
        }
        return new String(chrs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)((java.lang.Object)x1));
        }
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        public CologneInputBuffer(char[] data) {
            super(data);
        }

        public void addLeft(char ch) {
            ++this.length;
            this.data[this.getNextPos()] = ch;
        }

        protected char[] copyData(int start, int length) {
            char[] newData = new char[length];
            System.arraycopy((Object)this.data, (int)(this.data.length - this.length + start), (Object)newData, (int)0, (int)length);
            return newData;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        public char removeNext() {
            char ch = this.getNextChar();
            --this.length;
            return ch;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        public CologneOutputBuffer(int buffSize) {
            super(buffSize);
        }

        public void addRight(char chr) {
            this.data[this.length] = chr;
            ++this.length;
        }

        protected char[] copyData(int start, int length) {
            char[] newData = new char[length];
            System.arraycopy((Object)this.data, (int)start, (Object)newData, (int)0, (int)length);
            return newData;
        }
    }

    private abstract class CologneBuffer
    extends Object {
        protected final char[] data;
        protected int length = 0;

        public CologneBuffer(char[] data) {
            this.data = data;
            this.length = data.length;
        }

        public CologneBuffer(int buffSize) {
            this.data = new char[buffSize];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

