/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.binary;

import org.ocpsoft.prettytime.natty.java.io.UnsupportedEncodingException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;

public class StringUtils
extends Object {
    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.ISO-8859-1");
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.US-ASCII");
    }

    public static byte[] getBytesUtf16(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.UTF-16");
    }

    public static byte[] getBytesUtf16Be(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.UTF-16BE");
    }

    public static byte[] getBytesUtf16Le(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.UTF-16LE");
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytesUnchecked(string, (String)"org.ocpsoft.prettytime.natty.UTF-8");
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(new StringBuffer().append(charsetName).append((String)"org.ocpsoft.prettytime.natty.: ").append((Object)e).toString());
    }

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    public static String newStringIso8859_1(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.ISO-8859-1");
    }

    public static String newStringUsAscii(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.US-ASCII");
    }

    public static String newStringUtf16(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.UTF-16");
    }

    public static String newStringUtf16Be(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.UTF-16BE");
    }

    public static String newStringUtf16Le(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.UTF-16LE");
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, (String)"org.ocpsoft.prettytime.natty.UTF-8");
    }
}

