/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.apache.commons.codec.binary;

import org.ocpsoft.prettytime.natty.java.io.UnsupportedEncodingException;
import org.ocpsoft.prettytime.natty.java.lang.Character;
import org.ocpsoft.prettytime.natty.java.lang.ClassCastException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.BinaryDecoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.BinaryEncoder;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.DecoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.EncoderException;
import org.ocpsoft.prettytime.natty.org.apache.commons.codec.binary.StringUtils;

public class Hex
extends Object
implements BinaryEncoder,
BinaryDecoder {
    public static final String DEFAULT_CHARSET_NAME = "org.ocpsoft.prettytime.natty.UTF-8";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String charsetName;

    public static byte[] decodeHex(char[] data) throws DecoderException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new DecoderException((String)"org.ocpsoft.prettytime.natty.Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return new String(Hex.encodeHex(data));
    }

    protected static int toDigit(char ch, int index) throws DecoderException {
        int digit = Character.digit((char)ch, (int)16);
        if (digit == -1) {
            throw new DecoderException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Illegal hexadecimal character ").append(ch).append((String)"org.ocpsoft.prettytime.natty. at index ").append(index).toString());
        }
        return digit;
    }

    public Hex() {
        this.charsetName = "org.ocpsoft.prettytime.natty.UTF-8";
    }

    public Hex(String csName) {
        this.charsetName = csName;
    }

    public byte[] decode(byte[] array) throws DecoderException {
        try {
            return Hex.decodeHex(new String(array, this.getCharsetName()).toCharArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e) {
            throw new DecoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
    }

    public byte[] encode(byte[] array) {
        return StringUtils.getBytesUnchecked(Hex.encodeHexString(array), this.getCharsetName());
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes(this.getCharsetName()) : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e) {
            throw new EncoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e.getMessage(), (Throwable)((java.lang.Object)e));
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append((String)"org.ocpsoft.prettytime.natty.[charsetName=").append(this.charsetName).append((String)"org.ocpsoft.prettytime.natty.]").toString();
    }
}

