/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.antlr.stringtemplate;

import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.LinkedHashMap;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.org.antlr.stringtemplate.StringTemplate;
import org.ocpsoft.prettytime.natty.org.antlr.stringtemplate.StringTemplateErrorListener;
import org.ocpsoft.prettytime.natty.org.antlr.stringtemplate.StringTemplateGroup;
import org.ocpsoft.prettytime.natty.org.antlr.stringtemplate.language.InterfaceLexer;
import org.ocpsoft.prettytime.natty.org.antlr.stringtemplate.language.InterfaceParser;

public class StringTemplateGroupInterface
extends Object {
    protected String name;
    protected Map templates = new LinkedHashMap();
    protected StringTemplateGroupInterface superInterface = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String string, Throwable throwable) {
            System.err.println(string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }

        public void warning(String string) {
            System.out.println(string);
        }
    };

    public StringTemplateGroupInterface(Reader reader) {
        this(reader, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroupInterface(Reader reader, StringTemplateErrorListener stringTemplateErrorListener) {
        this(reader, stringTemplateErrorListener, null);
    }

    public StringTemplateGroupInterface(Reader reader, StringTemplateErrorListener stringTemplateErrorListener, StringTemplateGroupInterface stringTemplateGroupInterface) {
        this.listener = stringTemplateErrorListener;
        this.setSuperInterface(stringTemplateGroupInterface);
        this.parseInterface(reader);
    }

    public StringTemplateGroupInterface getSuperInterface() {
        return this.superInterface;
    }

    public void setSuperInterface(StringTemplateGroupInterface stringTemplateGroupInterface) {
        this.superInterface = stringTemplateGroupInterface;
    }

    protected void parseInterface(Reader reader) {
        try {
            InterfaceLexer interfaceLexer = new InterfaceLexer(reader);
            InterfaceParser interfaceParser = new InterfaceParser(interfaceLexer);
            interfaceParser.groupInterface(this);
        }
        catch (Exception exception) {
            java.lang.String string = "org.ocpsoft.prettytime.natty.<unknown>";
            if (this.getName() != null) {
                string = this.getName();
            }
            this.error(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.problem parsing group ").append((String)string).append((String)"org.ocpsoft.prettytime.natty.: ").append((Object)exception).toString(), exception);
        }
    }

    public void defineTemplate(String string, LinkedHashMap linkedHashMap, boolean bl) {
        TemplateDefinition templateDefinition = new TemplateDefinition(string, linkedHashMap, bl);
        this.templates.put((Object)templateDefinition.name, (Object)templateDefinition);
    }

    public List getMissingTemplates(StringTemplateGroup stringTemplateGroup) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get((Object)string);
            if (templateDefinition.optional || stringTemplateGroup.isDefined(templateDefinition.name)) continue;
            arrayList.add((Object)templateDefinition.name);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public List getMismatchedTemplates(StringTemplateGroup stringTemplateGroup) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get((Object)string);
            if (!stringTemplateGroup.isDefined(templateDefinition.name)) continue;
            StringTemplate stringTemplate = stringTemplateGroup.getTemplateDefinition(templateDefinition.name);
            Map map = stringTemplate.getFormalArguments();
            boolean bl = false;
            if (templateDefinition.formalArgs != null && map == null || templateDefinition.formalArgs == null && map != null || templateDefinition.formalArgs.size() != map.size()) {
                bl = true;
            }
            if (!bl) {
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (templateDefinition.formalArgs.get((Object)string2) != null) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add((Object)this.getTemplateSignature(templateDefinition));
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.listener != null) {
            this.listener.error(string, (Throwable)exception);
        } else {
            System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.StringTemplate: ").append(string).toString());
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)"org.ocpsoft.prettytime.natty.interface ");
        stringBuffer.append(this.getName());
        stringBuffer.append((String)"org.ocpsoft.prettytime.natty.;\n");
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TemplateDefinition templateDefinition = (TemplateDefinition)this.templates.get((Object)string);
            stringBuffer.append(this.getTemplateSignature(templateDefinition));
            stringBuffer.append((String)"org.ocpsoft.prettytime.natty.;\n");
        }
        return stringBuffer.toString();
    }

    protected String getTemplateSignature(TemplateDefinition templateDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        if (templateDefinition.optional) {
            stringBuffer.append((String)"org.ocpsoft.prettytime.natty.optional ");
        }
        stringBuffer.append(templateDefinition.name);
        if (templateDefinition.formalArgs != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append('(');
            int n = 1;
            Iterator iterator = templateDefinition.formalArgs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (n > 1) {
                    stringBuffer2.append((String)"org.ocpsoft.prettytime.natty., ");
                }
                stringBuffer2.append(string);
                ++n;
            }
            stringBuffer2.append(')');
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append((String)"org.ocpsoft.prettytime.natty.()");
        }
        return stringBuffer.toString();
    }

    static class TemplateDefinition
    extends Object {
        public String name;
        public LinkedHashMap formalArgs;
        public boolean optional = false;

        public TemplateDefinition(String string, LinkedHashMap linkedHashMap, boolean bl) {
            this.name = string;
            this.formalArgs = linkedHashMap;
            this.optional = bl;
        }
    }
}

