/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.antlr.runtime.tree;

import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.RuntimeException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.CommonTree;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.Tree;

public abstract class BaseTree
extends Object
implements Tree {
    protected List children;

    public BaseTree() {
    }

    public BaseTree(Tree node) {
    }

    public Tree getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(i);
    }

    public List getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int type) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Tree t = (Tree)this.children.get(i);
            if (t.getType() != type) continue;
            return t;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree t) {
        if (t == null) {
            return;
        }
        BaseTree childTree = (BaseTree)t;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException((String)"org.ocpsoft.prettytime.natty.attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n = childTree.children.size();
                    for (int i = 0; i < n; ++i) {
                        Tree c = (Tree)childTree.children.get(i);
                        this.children.add((Object)c);
                        c.setParent(this);
                        c.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add((Object)t);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List kids) {
        for (int i = 0; i < kids.size(); ++i) {
            Tree t = (Tree)kids.get(i);
            this.addChild(t);
        }
    }

    public void setChild(int i, Tree t) {
        if (t == null) {
            return;
        }
        if (t.isNil()) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i, (Object)t);
        t.setParent(this);
        t.setChildIndex(i);
    }

    public Object deleteChild(int i) {
        if (this.children == null) {
            return null;
        }
        Tree killed = (Tree)this.children.remove(i);
        this.freshenParentAndChildIndexes(i);
        return killed;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        if (this.children == null) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        BaseTree newTree = (BaseTree)t;
        List newChildren = null;
        if (newTree.isNil()) {
            newChildren = newTree.children;
        } else {
            newChildren = new ArrayList(1);
            newChildren.add((Object)newTree);
        }
        int replacingWithHowMany = newChildren.size();
        int numNewChildren = newChildren.size();
        int delta = replacingHowMany - replacingWithHowMany;
        if (delta == 0) {
            int j = 0;
            for (int i = startChildIndex; i <= stopChildIndex; ++i) {
                BaseTree child = (BaseTree)newChildren.get(j);
                this.children.set(i, (Object)child);
                child.setParent(this);
                child.setChildIndex(i);
                ++j;
            }
        } else if (delta > 0) {
            int indexToDelete;
            for (int j = 0; j < numNewChildren; ++j) {
                this.children.set(startChildIndex + j, newChildren.get(j));
            }
            for (int c = indexToDelete = startChildIndex + numNewChildren; c <= stopChildIndex; ++c) {
                this.children.remove(indexToDelete);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            for (int j = 0; j < replacingHowMany; ++j) {
                this.children.set(startChildIndex + j, newChildren.get(j));
            }
            int numToInsert = replacingWithHowMany - replacingHowMany;
            for (int j = replacingHowMany; j < replacingWithHowMany; ++j) {
                this.children.add(startChildIndex + j, newChildren.get(j));
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List createChildrenList() {
        return new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n = this.getChildCount();
        for (int c = offset; c < n; ++c) {
            Tree child = this.getChild(c);
            child.setChildIndex(c);
            child.setParent(this);
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree parent, int i) {
        if (parent != this.getParent()) {
            throw new IllegalStateException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.parents don't match; expected ").append((Object)parent).append((String)"org.ocpsoft.prettytime.natty. found ").append((Object)this.getParent()).toString());
        }
        if (i != this.getChildIndex()) {
            throw new IllegalStateException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.child indexes don't match; expected ").append(i).append((String)"org.ocpsoft.prettytime.natty. found ").append(this.getChildIndex()).toString());
        }
        int n = this.getChildCount();
        for (int c = 0; c < n; ++c) {
            CommonTree child = (CommonTree)this.getChild(c);
            child.sanityCheckParentAndChildIndexes(this, c);
        }
    }

    public int getChildIndex() {
        return 0;
    }

    public void setChildIndex(int index) {
    }

    public Tree getParent() {
        return null;
    }

    public void setParent(Tree t) {
    }

    public boolean hasAncestor(int ttype) {
        return this.getAncestor(ttype) != null;
    }

    public Tree getAncestor(int ttype) {
        Tree t = this;
        for (t = t.getParent(); t != null; t = t.getParent()) {
            if (t.getType() != ttype) continue;
            return t;
        }
        return null;
    }

    public List getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList ancestors = new ArrayList();
        Tree t = this;
        for (t = t.getParent(); t != null; t = t.getParent()) {
            ancestors.add(0, (Object)t);
        }
        return ancestors;
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isNil()) {
            buf.append((String)"org.ocpsoft.prettytime.natty.(");
            buf.append(this.toString());
            buf.append(' ');
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Tree t = (Tree)this.children.get(i);
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(t.toStringTree());
        }
        if (!this.isNil()) {
            buf.append((String)"org.ocpsoft.prettytime.natty.)");
        }
        return buf.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();
}

