/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.antlr.runtime.misc;

import org.ocpsoft.prettytime.natty.java.io.BufferedOutputStream;
import org.ocpsoft.prettytime.natty.java.io.File;
import org.ocpsoft.prettytime.natty.java.io.FileOutputStream;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.OutputStream;
import org.ocpsoft.prettytime.natty.java.io.PrintStream;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;

public class Stats
extends Object {
    public static final String ANTLRWORKS_DIR = "org.ocpsoft.prettytime.natty.antlrworks";

    public static double stddev(int[] X) {
        int m = X.length;
        if (m <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        for (int i = 0; i < m; ++i) {
            s2 += ((double)X[i] - xbar) * ((double)X[i] - xbar);
        }
        return Math.sqrt((double)(s2 /= (double)(m - 1)));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m = X.length;
        if (m == 0) {
            return 0.0;
        }
        for (int i = 0; i < m; ++i) {
            xbar += (double)X[i];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min = Integer.MAX_VALUE;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            if (X[i] >= min) continue;
            min = X[i];
        }
        return min;
    }

    public static int max(int[] X) {
        int max = Integer.MIN_VALUE;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            if (X[i] <= max) continue;
            max = X[i];
        }
        return max;
    }

    public static int sum(int[] X) {
        int s = 0;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            s += X[i];
        }
        return s;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
        PrintStream ps = new PrintStream((OutputStream)bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return new StringBuffer().append(System.getProperty((String)"org.ocpsoft.prettytime.natty.user.home")).append(File.separator).append((String)"org.ocpsoft.prettytime.natty.antlrworks").append(File.separator).append(filename).toString();
    }
}

