/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.antlr.runtime.debug;

import org.ocpsoft.prettytime.natty.java.io.BufferedReader;
import org.ocpsoft.prettytime.natty.java.io.BufferedWriter;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.InputStreamReader;
import org.ocpsoft.prettytime.natty.java.io.OutputStream;
import org.ocpsoft.prettytime.natty.java.io.OutputStreamWriter;
import org.ocpsoft.prettytime.natty.java.io.PrintWriter;
import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.io.Writer;
import org.ocpsoft.prettytime.natty.java.lang.Boolean;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.IllegalAccessException;
import org.ocpsoft.prettytime.natty.java.lang.InstantiationException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Runnable;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.net.ConnectException;
import org.ocpsoft.prettytime.natty.java.net.Socket;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.CharStream;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.RecognitionException;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.Token;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.debug.DebugEventListener;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.BaseTree;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.Tree;

public class RemoteDebugEventSocketListener
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements Runnable {
    static final int MAX_EVENT_ELEMENTS = 8;
    DebugEventListener listener;
    String machine;
    int port;
    Socket channel = null;
    PrintWriter out;
    BufferedReader in;
    String event;
    public String version;
    public String grammarFileName;
    int previousTokenIndex = -1;
    boolean tokenIndexesInvalid = false;

    public RemoteDebugEventSocketListener(DebugEventListener listener, String machine, int port) throws IOException {
        this.listener = listener;
        this.machine = machine;
        this.port = port;
        if (!this.openConnection()) {
            throw new ConnectException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventHandler() {
        try {
            this.handshake();
            this.event = this.in.readLine();
            while (this.event != null) {
                this.dispatch(this.event);
                this.ack();
                this.event = this.in.readLine();
            }
        }
        catch (Exception e) {
            System.err.println((org.ocpsoft.prettytime.natty.java.lang.Object)e);
            e.printStackTrace(System.err);
        }
        finally {
            this.closeConnection();
        }
    }

    protected boolean openConnection() {
        boolean success = false;
        try {
            this.channel = new Socket(this.machine, this.port);
            this.channel.setTcpNoDelay(true);
            OutputStream os = this.channel.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, (String)"org.ocpsoft.prettytime.natty.UTF8");
            this.out = new PrintWriter((Writer)new BufferedWriter((Writer)osw));
            InputStream is = this.channel.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, (String)"org.ocpsoft.prettytime.natty.UTF8");
            this.in = new BufferedReader((Reader)isr);
            success = true;
        }
        catch (Exception e) {
            System.err.println((org.ocpsoft.prettytime.natty.java.lang.Object)e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        try {
            this.in.close();
            this.in = null;
            this.out.close();
            this.out = null;
            this.channel.close();
            this.channel = null;
        }
        catch (Exception e) {
            System.err.println((org.ocpsoft.prettytime.natty.java.lang.Object)e);
            e.printStackTrace(System.err);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    System.err.println((org.ocpsoft.prettytime.natty.java.lang.Object)ioe);
                }
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException ioe) {
                    System.err.println((org.ocpsoft.prettytime.natty.java.lang.Object)ioe);
                }
            }
        }
    }

    protected void handshake() throws IOException {
        String antlrLine = this.in.readLine();
        String[] antlrElements = this.getEventElements(antlrLine);
        this.version = antlrElements[1];
        String grammarLine = this.in.readLine();
        String[] grammarElements = this.getEventElements(grammarLine);
        this.grammarFileName = grammarElements[1];
        this.ack();
        this.listener.commence();
    }

    protected void ack() {
        this.out.println((String)"org.ocpsoft.prettytime.natty.ack");
        this.out.flush();
    }

    protected void dispatch(String line) {
        String[] elements = this.getEventElements(line);
        if (elements == null || elements[0] == null) {
            System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.unknown debug event: ").append(line).toString());
            return;
        }
        if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.enterRule")) {
            this.listener.enterRule(elements[1], elements[2]);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.exitRule")) {
            this.listener.exitRule(elements[1], elements[2]);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.enterAlt")) {
            this.listener.enterAlt(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.enterSubRule")) {
            this.listener.enterSubRule(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.exitSubRule")) {
            this.listener.exitSubRule(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.enterDecision")) {
            this.listener.enterDecision(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.exitDecision")) {
            this.listener.exitDecision(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.location")) {
            this.listener.location(Integer.parseInt((String)elements[1]), Integer.parseInt((String)elements[2]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.consumeToken")) {
            ProxyToken t = this.deserializeToken(elements, 1);
            if (t.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = t.getTokenIndex();
            this.listener.consumeToken(t);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.consumeHiddenToken")) {
            ProxyToken t = this.deserializeToken(elements, 1);
            if (t.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = t.getTokenIndex();
            this.listener.consumeHiddenToken(t);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.LT")) {
            ProxyToken t = this.deserializeToken(elements, 2);
            this.listener.LT(Integer.parseInt((String)elements[1]), t);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.mark")) {
            this.listener.mark(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.rewind")) {
            if (elements[1] != null) {
                this.listener.rewind(Integer.parseInt((String)elements[1]));
            } else {
                this.listener.rewind();
            }
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.beginBacktrack")) {
            this.listener.beginBacktrack(Integer.parseInt((String)elements[1]));
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.endBacktrack")) {
            int level = Integer.parseInt((String)elements[1]);
            int successI = Integer.parseInt((String)elements[2]);
            this.listener.endBacktrack(level, successI == 1);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.exception")) {
            String excName = elements[1];
            String indexS = elements[2];
            String lineS = elements[3];
            String posS = elements[4];
            Class excClass = null;
            try {
                excClass = Class.forName((String)excName);
                RecognitionException e = (RecognitionException)excClass.newInstance();
                e.index = Integer.parseInt((String)indexS);
                e.line = Integer.parseInt((String)lineS);
                e.charPositionInLine = Integer.parseInt((String)posS);
                this.listener.recognitionException(e);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.can't find class ").append((org.ocpsoft.prettytime.natty.java.lang.Object)cnfe).toString());
                cnfe.printStackTrace(System.err);
            }
            catch (InstantiationException ie) {
                System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.can't instantiate class ").append((org.ocpsoft.prettytime.natty.java.lang.Object)ie).toString());
                ie.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.can't access class ").append((org.ocpsoft.prettytime.natty.java.lang.Object)iae).toString());
                iae.printStackTrace(System.err);
            }
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.beginResync")) {
            this.listener.beginResync();
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.endResync")) {
            this.listener.endResync();
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.terminate")) {
            this.listener.terminate();
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.semanticPredicate")) {
            Boolean result = Boolean.valueOf((String)elements[1]);
            String predicateText = elements[2];
            predicateText = this.unEscapeNewlines(predicateText);
            this.listener.semanticPredicate(result.booleanValue(), predicateText);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.consumeNode")) {
            ProxyTree node = this.deserializeNode(elements, 1);
            this.listener.consumeNode(node);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.LN")) {
            int i = Integer.parseInt((String)elements[1]);
            ProxyTree node = this.deserializeNode(elements, 2);
            this.listener.LT(i, node);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.createNodeFromTokenElements")) {
            int ID = Integer.parseInt((String)elements[1]);
            int type = Integer.parseInt((String)elements[2]);
            String text = elements[3];
            text = this.unEscapeNewlines(text);
            ProxyTree node = new ProxyTree(ID, type, -1, -1, -1, text);
            this.listener.createNode(node);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.createNode")) {
            int ID = Integer.parseInt((String)elements[1]);
            int tokenIndex = Integer.parseInt((String)elements[2]);
            ProxyTree node = new ProxyTree(ID);
            ProxyToken token = new ProxyToken(tokenIndex);
            this.listener.createNode(node, token);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.nilNode")) {
            int ID = Integer.parseInt((String)elements[1]);
            ProxyTree node = new ProxyTree(ID);
            this.listener.nilNode(node);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.errorNode")) {
            int ID = Integer.parseInt((String)elements[1]);
            int type = Integer.parseInt((String)elements[2]);
            String text = elements[3];
            text = this.unEscapeNewlines(text);
            ProxyTree node = new ProxyTree(ID, type, -1, -1, -1, text);
            this.listener.errorNode(node);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.becomeRoot")) {
            int newRootID = Integer.parseInt((String)elements[1]);
            int oldRootID = Integer.parseInt((String)elements[2]);
            ProxyTree newRoot = new ProxyTree(newRootID);
            ProxyTree oldRoot = new ProxyTree(oldRootID);
            this.listener.becomeRoot(newRoot, oldRoot);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.addChild")) {
            int rootID = Integer.parseInt((String)elements[1]);
            int childID = Integer.parseInt((String)elements[2]);
            ProxyTree root = new ProxyTree(rootID);
            ProxyTree child = new ProxyTree(childID);
            this.listener.addChild(root, child);
        } else if (elements[0].equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.setTokenBoundaries")) {
            int ID = Integer.parseInt((String)elements[1]);
            ProxyTree node = new ProxyTree(ID);
            this.listener.setTokenBoundaries(node, Integer.parseInt((String)elements[2]), Integer.parseInt((String)elements[3]));
        } else {
            System.err.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.unknown debug event: ").append(line).toString());
        }
    }

    protected ProxyTree deserializeNode(String[] elements, int offset) {
        int ID = Integer.parseInt((String)elements[offset + 0]);
        int type = Integer.parseInt((String)elements[offset + 1]);
        int tokenLine = Integer.parseInt((String)elements[offset + 2]);
        int charPositionInLine = Integer.parseInt((String)elements[offset + 3]);
        int tokenIndex = Integer.parseInt((String)elements[offset + 4]);
        String text = elements[offset + 5];
        text = this.unEscapeNewlines(text);
        return new ProxyTree(ID, type, tokenLine, charPositionInLine, tokenIndex, text);
    }

    protected ProxyToken deserializeToken(String[] elements, int offset) {
        String indexS = elements[offset + 0];
        String typeS = elements[offset + 1];
        String channelS = elements[offset + 2];
        String lineS = elements[offset + 3];
        String posS = elements[offset + 4];
        String text = elements[offset + 5];
        text = this.unEscapeNewlines(text);
        int index = Integer.parseInt((String)indexS);
        ProxyToken t = new ProxyToken(index, Integer.parseInt((String)typeS), Integer.parseInt((String)channelS), Integer.parseInt((String)lineS), Integer.parseInt((String)posS), text);
        return t;
    }

    public void start() {
        Thread t = new Thread((Runnable)this);
        t.start();
    }

    public void run() {
        this.eventHandler();
    }

    public String[] getEventElements(String event) {
        if (event == null) {
            return null;
        }
        String[] elements = new String[8];
        String str = null;
        try {
            int firstQuoteIndex = event.indexOf(34);
            if (firstQuoteIndex >= 0) {
                String eventWithoutString = event.substring(0, firstQuoteIndex);
                str = event.substring(firstQuoteIndex + 1, event.length());
                event = eventWithoutString;
            }
            StringTokenizer st = new StringTokenizer(event, (String)"org.ocpsoft.prettytime.natty.\t", false);
            int i = 0;
            while (st.hasMoreTokens()) {
                if (i >= 8) {
                    return elements;
                }
                elements[i] = st.nextToken();
                ++i;
            }
            if (str != null) {
                elements[i] = str;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return elements;
    }

    protected String unEscapeNewlines(String txt) {
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.%0A", (String)"org.ocpsoft.prettytime.natty.\n");
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.%0D", (String)"org.ocpsoft.prettytime.natty.\r");
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.%25", (String)"org.ocpsoft.prettytime.natty.%");
        return txt;
    }

    public boolean tokenIndexesAreInvalid() {
        return false;
    }

    public static class ProxyTree
    extends BaseTree {
        public int ID;
        public int type;
        public int line = 0;
        public int charPos = -1;
        public int tokenIndex = -1;
        public String text;

        public ProxyTree(int ID, int type, int line, int charPos, int tokenIndex, String text) {
            this.ID = ID;
            this.type = type;
            this.line = line;
            this.charPos = charPos;
            this.tokenIndex = tokenIndex;
            this.text = text;
        }

        public ProxyTree(int ID) {
            this.ID = ID;
        }

        public int getTokenStartIndex() {
            return this.tokenIndex;
        }

        public void setTokenStartIndex(int index) {
        }

        public int getTokenStopIndex() {
            return 0;
        }

        public void setTokenStopIndex(int index) {
        }

        public Tree dupNode() {
            return null;
        }

        public int getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "org.ocpsoft.prettytime.natty.fix this";
        }
    }

    public static class ProxyToken
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Token {
        int index;
        int type;
        int channel;
        int line;
        int charPos;
        String text;

        public ProxyToken(int index) {
            this.index = index;
        }

        public ProxyToken(int index, int type, int channel, int line, int charPos, String text) {
            this.index = index;
            this.type = type;
            this.channel = channel;
            this.line = line;
            this.charPos = charPos;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int ttype) {
            this.type = ttype;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getCharPositionInLine() {
            return this.charPos;
        }

        public void setCharPositionInLine(int pos) {
            this.charPos = pos;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int channel) {
            this.channel = channel;
        }

        public int getTokenIndex() {
            return this.index;
        }

        public void setTokenIndex(int index) {
            this.index = index;
        }

        public CharStream getInputStream() {
            return null;
        }

        public void setInputStream(CharStream input) {
        }

        public String toString() {
            java.lang.String channelStr = "org.ocpsoft.prettytime.natty.";
            if (this.channel != 0) {
                channelStr = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.,channel=").append(this.channel).toString();
            }
            return new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[").append(this.getText()).append((String)"org/ocpsoft/prettytime/natty//<").append(this.type).append((String)"org.ocpsoft.prettytime.natty.>").append((String)channelStr).append((String)"org.ocpsoft.prettytime.natty.,").append(this.line).append((String)"org.ocpsoft.prettytime.natty.:").append(this.getCharPositionInLine()).append((String)"org.ocpsoft.prettytime.natty.,@").append(this.index).append((String)"org.ocpsoft.prettytime.natty.]").toString();
        }
    }
}

