/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.org.antlr.runtime.debug;

import org.ocpsoft.prettytime.natty.java.io.BufferedReader;
import org.ocpsoft.prettytime.natty.java.io.BufferedWriter;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.InputStreamReader;
import org.ocpsoft.prettytime.natty.java.io.OutputStream;
import org.ocpsoft.prettytime.natty.java.io.OutputStreamWriter;
import org.ocpsoft.prettytime.natty.java.io.PrintWriter;
import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.io.Writer;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.net.ServerSocket;
import org.ocpsoft.prettytime.natty.java.net.Socket;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.BaseRecognizer;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.RecognitionException;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.Token;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.debug.BlankDebugEventListener;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.TreeAdaptor;

public class DebugEventSocketProxy
extends BlankDebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49100;
    protected int port = 49100;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected String grammarFileName;
    protected PrintWriter out;
    protected BufferedReader in;
    protected BaseRecognizer recognizer;
    protected TreeAdaptor adaptor;

    public DebugEventSocketProxy(BaseRecognizer recognizer, TreeAdaptor adaptor) {
        this(recognizer, 49100, adaptor);
    }

    public DebugEventSocketProxy(BaseRecognizer recognizer, int port, TreeAdaptor adaptor) {
        this.grammarFileName = recognizer.getGrammarFileName();
        this.adaptor = adaptor;
        this.port = port;
    }

    public void handshake() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream os = this.socket.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, (String)"org.ocpsoft.prettytime.natty.UTF8");
            this.out = new PrintWriter((Writer)new BufferedWriter((Writer)osw));
            InputStream is = this.socket.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, (String)"org.ocpsoft.prettytime.natty.UTF8");
            this.in = new BufferedReader((Reader)isr);
            this.out.println((String)"org.ocpsoft.prettytime.natty.ANTLR 2");
            this.out.println(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.grammar \"").append(this.grammarFileName).toString());
            this.out.flush();
            this.ack();
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit((String)"org.ocpsoft.prettytime.natty.terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    protected void transmit(String event) {
        this.out.println(event);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String grammarFileName, String ruleName) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.enterRule\t").append(grammarFileName).append((String)"org.ocpsoft.prettytime.natty.\t").append(ruleName).toString());
    }

    public void enterAlt(int alt) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.enterAlt\t").append(alt).toString());
    }

    public void exitRule(String grammarFileName, String ruleName) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.exitRule\t").append(grammarFileName).append((String)"org.ocpsoft.prettytime.natty.\t").append(ruleName).toString());
    }

    public void enterSubRule(int decisionNumber) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.enterSubRule\t").append(decisionNumber).toString());
    }

    public void exitSubRule(int decisionNumber) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.exitSubRule\t").append(decisionNumber).toString());
    }

    public void enterDecision(int decisionNumber) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.enterDecision\t").append(decisionNumber).toString());
    }

    public void exitDecision(int decisionNumber) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.exitDecision\t").append(decisionNumber).toString());
    }

    public void consumeToken(Token t) {
        String buf = this.serializeToken(t);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.consumeToken\t").append(buf).toString());
    }

    public void consumeHiddenToken(Token t) {
        String buf = this.serializeToken(t);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.consumeHiddenToken\t").append(buf).toString());
    }

    public void LT(int i, Token t) {
        if (t != null) {
            this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.LT\t").append(i).append((String)"org.ocpsoft.prettytime.natty.\t").append(this.serializeToken(t)).toString());
        }
    }

    public void mark(int i) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.mark\t").append(i).toString());
    }

    public void rewind(int i) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.rewind\t").append(i).toString());
    }

    public void rewind() {
        this.transmit((String)"org.ocpsoft.prettytime.natty.rewind");
    }

    public void beginBacktrack(int level) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.beginBacktrack\t").append(level).toString());
    }

    public void endBacktrack(int level, boolean successful) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.endBacktrack\t").append(level).append((String)"org.ocpsoft.prettytime.natty.\t").append(successful ? 1 : 0).toString());
    }

    public void location(int line, int pos) {
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.location\t").append(line).append((String)"org.ocpsoft.prettytime.natty.\t").append(pos).toString());
    }

    public void recognitionException(RecognitionException e) {
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.exception\t");
        buf.append(e.getClass().getName());
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(e.index);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(e.line);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(e.charPositionInLine);
        this.transmit(buf.toString());
    }

    public void beginResync() {
        this.transmit((String)"org.ocpsoft.prettytime.natty.beginResync");
    }

    public void endResync() {
        this.transmit((String)"org.ocpsoft.prettytime.natty.endResync");
    }

    public void semanticPredicate(boolean result, String predicate) {
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.semanticPredicate\t");
        buf.append(result);
        this.serializeText(buf, predicate);
        this.transmit(buf.toString());
    }

    public void consumeNode(Object t) {
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.consumeNode");
        this.serializeNode(buf, t);
        this.transmit(buf.toString());
    }

    public void LT(int i, Object t) {
        int ID = this.adaptor.getUniqueID(t);
        String text = this.adaptor.getText(t);
        int type = this.adaptor.getType(t);
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.LN\t");
        buf.append(i);
        this.serializeNode(buf, t);
        this.transmit(buf.toString());
    }

    protected void serializeNode(StringBuffer buf, Object t) {
        int ID = this.adaptor.getUniqueID(t);
        String text = this.adaptor.getText(t);
        int type = this.adaptor.getType(t);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(ID);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(type);
        Token token = this.adaptor.getToken(t);
        int line = -1;
        int pos = -1;
        if (token != null) {
            line = token.getLine();
            pos = token.getCharPositionInLine();
        }
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(line);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(pos);
        int tokenIndex = this.adaptor.getTokenStartIndex(t);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(tokenIndex);
        this.serializeText(buf, text);
    }

    public void nilNode(Object t) {
        int ID = this.adaptor.getUniqueID(t);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.nilNode\t").append(ID).toString());
    }

    public void errorNode(Object t) {
        int ID = this.adaptor.getUniqueID(t);
        String text = t.toString();
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.errorNode\t");
        buf.append(ID);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(0);
        this.serializeText(buf, text);
        this.transmit(buf.toString());
    }

    public void createNode(Object t) {
        int ID = this.adaptor.getUniqueID(t);
        String text = this.adaptor.getText(t);
        int type = this.adaptor.getType(t);
        StringBuffer buf = new StringBuffer(50);
        buf.append((String)"org.ocpsoft.prettytime.natty.createNodeFromTokenElements\t");
        buf.append(ID);
        buf.append((String)"org.ocpsoft.prettytime.natty.\t");
        buf.append(type);
        this.serializeText(buf, text);
        this.transmit(buf.toString());
    }

    public void createNode(Object node, Token token) {
        int ID = this.adaptor.getUniqueID(node);
        int tokenIndex = token.getTokenIndex();
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.createNode\t").append(ID).append((String)"org.ocpsoft.prettytime.natty.\t").append(tokenIndex).toString());
    }

    public void becomeRoot(Object newRoot, Object oldRoot) {
        int newRootID = this.adaptor.getUniqueID(newRoot);
        int oldRootID = this.adaptor.getUniqueID(oldRoot);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.becomeRoot\t").append(newRootID).append((String)"org.ocpsoft.prettytime.natty.\t").append(oldRootID).toString());
    }

    public void addChild(Object root, Object child) {
        int rootID = this.adaptor.getUniqueID(root);
        int childID = this.adaptor.getUniqueID(child);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.addChild\t").append(rootID).append((String)"org.ocpsoft.prettytime.natty.\t").append(childID).toString());
    }

    public void setTokenBoundaries(Object t, int tokenStartIndex, int tokenStopIndex) {
        int ID = this.adaptor.getUniqueID(t);
        this.transmit(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.setTokenBoundaries\t").append(ID).append((String)"org.ocpsoft.prettytime.natty.\t").append(tokenStartIndex).append((String)"org.ocpsoft.prettytime.natty.\t").append(tokenStopIndex).toString());
    }

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    protected String serializeToken(Token t) {
        StringBuffer buf = new StringBuffer(50);
        buf.append(t.getTokenIndex());
        buf.append('\t');
        buf.append(t.getType());
        buf.append('\t');
        buf.append(t.getChannel());
        buf.append('\t');
        buf.append(t.getLine());
        buf.append('\t');
        buf.append(t.getCharPositionInLine());
        this.serializeText(buf, t.getText());
        return buf.toString();
    }

    protected void serializeText(StringBuffer buf, String text) {
        buf.append((String)"org.ocpsoft.prettytime.natty.\t\"");
        if (text == null) {
            text = "org.ocpsoft.prettytime.natty.";
        }
        text = this.escapeNewlines((String)text);
        buf.append(text);
    }

    protected String escapeNewlines(String txt) {
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.%", (String)"org.ocpsoft.prettytime.natty.%25");
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.\n", (String)"org.ocpsoft.prettytime.natty.%0A");
        txt = txt.replaceAll((String)"org.ocpsoft.prettytime.natty.\r", (String)"org.ocpsoft.prettytime.natty.%0D");
        return txt;
    }
}

