/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util;

import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.regex.Pattern;

public final class Strings
extends Object {
    public static final Pattern PARAM_QUOTE_PATTERN = Pattern.compile((String)"org.ocpsoft.prettytime.natty.[:;,]|[^\\p{ASCII}]");
    public static final String LINE_SEPARATOR = "org.ocpsoft.prettytime.natty.\r\n";

    private Strings() {
    }

    public static String quote(Object aValue) {
        if (aValue != null) {
            return new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.\"").append(aValue).append((String)"org.ocpsoft.prettytime.natty.\"").toString();
        }
        return "org.ocpsoft.prettytime.natty.\"\"";
    }

    public static String unquote(String aValue) {
        if (aValue != null && aValue.startsWith((String)"org.ocpsoft.prettytime.natty.\"") && aValue.endsWith((String)"org.ocpsoft.prettytime.natty.\"")) {
            return aValue.substring(0, aValue.length() - 1).substring(1);
        }
        return aValue;
    }

    public static String escape(String aValue) {
        return Strings.escapePunctuation(Strings.escapeNewline(Strings.escapeBackslash(aValue)));
    }

    public static String unescape(String aValue) {
        return Strings.unescapeBackslash(Strings.unescapeNewline(Strings.unescapePunctuation(aValue)));
    }

    private static String escapePunctuation(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.([,;])", (String)"org.ocpsoft.prettytime.natty.\\\\$1");
        }
        return value;
    }

    private static String unescapePunctuation(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.\\\\([,;\"])", (String)"org.ocpsoft.prettytime.natty.$1");
        }
        return value;
    }

    private static String escapeNewline(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.\r?\n", (String)"org.ocpsoft.prettytime.natty.\\\\n");
        }
        return value;
    }

    private static String unescapeNewline(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.(?<!\\\\)\\\\n", (String)"org.ocpsoft.prettytime.natty.\n");
        }
        return value;
    }

    private static String escapeBackslash(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.\\\\", (String)"org.ocpsoft.prettytime.natty.\\\\\\\\");
        }
        return value;
    }

    private static String unescapeBackslash(String value) {
        if (value != null) {
            return value.replaceAll((String)"org.ocpsoft.prettytime.natty.\\\\\\\\", (String)"org.ocpsoft.prettytime.natty.\\\\");
        }
        return value;
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "org.ocpsoft.prettytime.natty.";
        }
        return object.toString();
    }
}

