/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util;

import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;

public final class PropertyValidator
extends Object {
    private static final String ASSERT_NONE_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}] is not applicable";
    private static final String ASSERT_ONE_OR_LESS_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}] must only be specified once";
    private static final String ASSERT_ONE_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}] must be specified once";
    private static final String ASSERT_ONE_OR_MORE_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}] must be specified at least once";
    private static PropertyValidator instance = new PropertyValidator();

    private PropertyValidator() {
    }

    public void assertOneOrLess(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() > 1) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [{0}] must only be specified once", new Object[]{propertyName});
        }
    }

    public void assertOneOrMore(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() < 1) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [{0}] must be specified at least once", new Object[]{propertyName});
        }
    }

    public void assertOne(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() != 1) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [{0}] must be specified once", new Object[]{propertyName});
        }
    }

    public void assertNone(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperty(propertyName) != null) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [{0}] is not applicable", new Object[]{propertyName});
        }
    }

    public static PropertyValidator getInstance() {
        return instance;
    }
}

